/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.queries;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.galaxy.context.GalaxyContext;
import org.springframework.data.neo4j.examples.galaxy.domain.World;
import org.springframework.data.neo4j.examples.galaxy.repo.WorldRepository;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={GalaxyContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class QueryReturnTypesTest
extends MultiDriverTestClass {
    @Autowired
    WorldRepository worldRepository;

    @Test
    public void shouldCallExecuteWhenPrimitiveVoidReturnTypeOnQuery() {
        World world = new World("Tatooine", 0);
        this.worldRepository.save(world);
        this.worldRepository.touchAllWorlds();
        world = (World)this.worldRepository.findOne(world.getId());
        Assert.assertNotNull((Object)world.getUpdated());
    }

    @Test
    public void shouldCallExecuteWhenVoidReturnTypeOnQuery() {
        World tatooine = new World("Tatooine", 0);
        World dagobah = new World("Dagobah", 0);
        tatooine.addRocketRouteTo(dagobah);
        this.worldRepository.save(tatooine);
        this.worldRepository.touchAllWorlds();
        tatooine = (World)this.worldRepository.findOne(tatooine.getId());
        Assert.assertNotNull((Object)tatooine.getUpdated());
        Assert.assertEquals((long)1L, (long)tatooine.getReachableByRocket().size());
        for (World world : tatooine.getReachableByRocket()) {
            Assert.assertNotNull((Object)world.getUpdated());
        }
    }

    @Test
    public void shouldReturnStatisticsIfRequested() {
        World tatooine = new World("Tatooine", 0);
        this.worldRepository.save(tatooine);
        QueryStatistics stats = this.worldRepository.touchAllWorldsWithStatistics().queryStatistics();
        Assert.assertEquals((long)1L, (long)stats.getPropertiesSet());
    }
}

