/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.data.neo4j.repositories.domain.Movie;
import org.springframework.data.neo4j.repositories.repo.MovieRepository;
import org.springframework.data.neo4j.repository.support.GraphRepositoryFactory;
import org.springframework.data.neo4j.util.IterableUtils;

public class ProgrammaticRepositoryTest
extends MultiDriverTestClass {
    private MovieRepository movieRepository;
    private SessionFactory sessionFactory = new SessionFactory(new String[]{"org.springframework.data.neo4j.repositories.domain"});
    private Session session;

    @Before
    public void init() {
        this.session = this.sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void canInstantiateRepositoryProgrammatically() {
        GraphRepositoryFactory factory = new GraphRepositoryFactory(this.session);
        this.movieRepository = (MovieRepository)factory.getRepository(MovieRepository.class);
        Movie movie = new Movie("PF");
        this.movieRepository.save(movie);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ProgrammaticRepositoryTest.getGraphDatabaseService(), (String)"CREATE (m:Movie {title:'PF'})");
        Assert.assertEquals((long)1L, (long)IterableUtils.count(this.movieRepository.findAll()));
    }
}

