/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.examples.movies.domain.Actor;
import org.springframework.data.neo4j.examples.movies.domain.Cinema;
import org.springframework.data.neo4j.examples.movies.domain.Genre;
import org.springframework.data.neo4j.examples.movies.domain.Rating;
import org.springframework.data.neo4j.examples.movies.domain.TempMovie;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.template.context.Neo4jTemplateConfiguration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={Neo4jTemplateConfiguration.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class Neo4jTemplateTest
extends MultiDriverTestClass {
    private GraphDatabaseService graphDatabaseService = Neo4jTemplateTest.getGraphDatabaseService();
    @Autowired
    private Neo4jOperations template;
    @Autowired
    private Session session;

    @Before
    public void setUpOgmSession() {
        this.clearDatabase();
        this.addArbitraryDataToDatabase();
    }

    @After
    public void clearDatabase() {
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            this.graphDatabaseService.execute("MATCH (n) OPTIONAL MATCH (n)-[r]-() DELETE r, n");
            tx.success();
        }
    }

    private void addArbitraryDataToDatabase() {
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            Node arbitraryNode = this.graphDatabaseService.createNode(new Label[]{DynamicLabel.label((String)"NotAClass")});
            arbitraryNode.setProperty("name", (Object)"Colin");
            Node otherNode = this.graphDatabaseService.createNode(new Label[]{DynamicLabel.label((String)"NotAClass")});
            otherNode.setProperty("age", (Object)39);
            arbitraryNode.createRelationshipTo(otherNode, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
            tx.success();
        }
    }

    @Test
    public void shouldSaveAndRetrieveNodeEntitiesWithoutExplicitTransactionManagement() {
        Genre filmGenre = new Genre();
        filmGenre.setName("Comedy");
        this.template.save((Object)filmGenre);
        Genre loadedGenre = (Genre)this.template.load(Genre.class, filmGenre.getId());
        Assert.assertNotNull((String)"The entity loaded from the template shouldn't be null", (Object)loadedGenre);
        Assert.assertEquals((String)"The loaded entity wasn't as expected", (Object)filmGenre, (Object)loadedGenre);
        Genre anotherGenre = new Genre();
        anotherGenre.setName("Action");
        this.template.save((Object)anotherGenre);
        Collection allGenres = this.template.loadAll(Genre.class);
        Assert.assertNotNull((String)"The collection of all genres shouldn't be null", (Object)allGenres);
        Assert.assertEquals((String)"The number of genres in the database wasn't as expected", (long)2L, (long)allGenres.size());
    }

    @Test
    public void shouldSaveAndRetrieveRelationshipEntitiesWithoutExplicitTransactionManagement() {
        User critic = new User("Gary");
        TempMovie film = new TempMovie("Fast and Furious XVII");
        Rating filmRating = critic.rate(film, 2, "They've made far too many of these films now!");
        this.template.save((Object)filmRating);
        Rating loadedRating = (Rating)this.template.load(Rating.class, filmRating.getId());
        Assert.assertNotNull((String)"The loaded rating shouldn't be null", (Object)loadedRating);
        Assert.assertEquals((String)"The relationship properties weren't saved correctly", (long)filmRating.getStars(), (long)loadedRating.getStars());
        Assert.assertEquals((String)"The rated film wasn't saved correctly", (Object)film.getName(), (Object)loadedRating.getMovie().getName());
        Assert.assertEquals((String)"The critic wasn't saved correctly", (Object)critic.getId(), (Object)loadedRating.getUser().getId());
    }

    @Test
    public void shouldExecuteArbitraryReadQuery() {
        User user = new User("Harmanpreet Singh");
        TempMovie bollywood = new TempMovie("Desi Boyz");
        TempMovie hollywood = new TempMovie("Mission Impossible");
        this.template.save((Object)user.rate(bollywood, 1, "Bakwaas"));
        this.template.save((Object)user.rate(hollywood, 4, "Pretty good"));
        Result queryResults = this.template.query("MATCH (u:User)-[r]->(m:Movie) RETURN AVG(r.stars) AS avg", Collections.EMPTY_MAP);
        Iterator queryResultIterator = queryResults.iterator();
        Assert.assertTrue((String)"There should've been some query result returned", (boolean)queryResultIterator.hasNext());
        Assert.assertEquals((double)2.5, (double)((Double)((Map)queryResultIterator.next()).get("avg")), (double)0.01);
    }

    @Test
    public void shouldQueryForSpecificObjectUsingBespokeParameterisedCypherQuery() {
        this.template.save((Object)new Actor("ab", "Alec Baldwin"));
        this.template.save((Object)new Actor("hm", "Helen Mirren"));
        this.template.save((Object)new Actor("md", "Matt Damon"));
        Actor loadedActor = (Actor)this.template.queryForObject(Actor.class, "MATCH (a:Actor) WHERE a.name={param} RETURN a", Collections.singletonMap("param", "Alec Baldwin"));
        Assert.assertNotNull((String)"The entity wasn't loaded", (Object)loadedActor);
        Assert.assertEquals((Object)"Alec Baldwin", (Object)loadedActor.getName());
    }

    @Test
    public void shouldQueryForObjectCollectionUsingBespokeCypherQuery() {
        this.template.save((Object)new User("Jeff"));
        this.template.save((Object)new User("John"));
        this.template.save((Object)new User("Colin"));
        Iterable users = this.template.queryForObjects(User.class, "MATCH (u:User) WHERE u.name=~'J.*' RETURN u", Collections.emptyMap());
        Assert.assertNotNull((String)"The entity wasn't loaded", (Object)users);
        Assert.assertTrue((String)"The entity wasn't loaded", (boolean)users.iterator().hasNext());
        for (User loadedUser : users) {
            Assert.assertTrue((String)("Shouldn't've loaded " + loadedUser.getName()), (loadedUser.getName().equals("John") || loadedUser.getName().equals("Jeff") ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldRetrieveEntitiesByMatchingProperty() {
        this.template.save((Object)new Genre("Thriller"));
        this.template.save((Object)new Genre("Horror"));
        this.template.save((Object)new Genre("Period Drama"));
        Genre loadedGenre = (Genre)this.template.loadByProperty(Genre.class, "name", (Object)"Horror");
        Assert.assertNotNull((String)"No genre was loaded", (Object)loadedGenre);
        Assert.assertEquals((Object)"Horror", (Object)loadedGenre.getName());
    }

    @Test
    public void shouldRetrieveEntitiesByMatchingPropertyAndDepth() {
        User user = new User("Harmanpreet Singh");
        TempMovie bollywood = new TempMovie("Desi Boyz");
        TempMovie hollywood = new TempMovie("Mission Impossible");
        this.template.save((Object)user.rate(bollywood, 1, "Bakwaas"));
        this.template.save((Object)user.rate(hollywood, 4, "Pretty good"));
        this.session.clear();
        User u = (User)this.template.loadByProperty(User.class, "name", (Object)"Harmanpreet Singh", 0);
        Assert.assertEquals((long)0L, (long)u.getRatings().size());
        u = (User)this.template.loadByProperty(User.class, "name", (Object)"Harmanpreet Singh", 2);
        Assert.assertEquals((long)2L, (long)u.getRatings().size());
        Assert.assertNotNull(u.getRatings().iterator().next().getMovie().getRatings());
    }

    @Test
    public void shouldRetrieveAllEntitiesByMatchingPropertyAndDepth() {
        User user = new User("Harmanpreet Singh");
        TempMovie bollywood = new TempMovie("Desi Boyz");
        TempMovie hollywood = new TempMovie("Desi Boyz");
        this.template.save((Object)user.rate(bollywood, 1, "Bakwaas"));
        this.template.save((Object)user.rate(hollywood, 4, "Pretty good"));
        this.template.clear();
        Collection m = this.template.loadAllByProperty(TempMovie.class, "name", (Object)"Desi Boyz", 0);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((long)0L, (long)((TempMovie)m.iterator().next()).getRatings().size());
        m = this.template.loadAllByProperty(TempMovie.class, "name", (Object)"Desi Boyz", 1);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((long)1L, (long)((TempMovie)m.iterator().next()).getRatings().size());
    }

    @Test
    public void shouldRetrieveEntitiesByMatchingPropertiesAndDepth() {
        User user = new User("Harmanpreet Singh");
        user.setMiddleName("A");
        User user2 = new User("Harmanpreet Singh");
        user2.setMiddleName("B");
        TempMovie bollywood = new TempMovie("Desi Boyz");
        TempMovie hollywood = new TempMovie("Mission Impossible");
        this.template.save((Object)user.rate(bollywood, 1, "Bakwaas"));
        this.template.save((Object)user.rate(hollywood, 4, "Pretty good"));
        this.template.save((Object)user2);
        this.session.clear();
        Filter nameFilter = new Filter("name", (Object)"Harmanpreet Singh");
        Filter middleNameFilter = new Filter("middleName", (Object)"A");
        middleNameFilter.setBooleanOperator(BooleanOperator.AND);
        Filters filters = new Filters();
        filters.add(new Filter[]{nameFilter, middleNameFilter});
        User u = (User)this.template.loadByProperties(User.class, filters, 0);
        Assert.assertEquals((long)0L, (long)u.getRatings().size());
        u = (User)this.template.loadByProperties(User.class, filters, 2);
        Assert.assertEquals((long)2L, (long)u.getRatings().size());
        Assert.assertNotNull(u.getRatings().iterator().next().getMovie().getRatings());
    }

    @Test
    public void shouldRetrieveAllEntitiesByMatchingPropertiesAndDepth() {
        User user = new User("Harmanpreet Singh");
        user.setMiddleName("A");
        User user2 = new User("Harmanpreet Singh");
        user2.setMiddleName("A");
        TempMovie bollywood = new TempMovie("Desi Boyz");
        TempMovie hollywood = new TempMovie("Mission Impossible");
        this.template.save((Object)user.rate(bollywood, 1, "Bakwaas"));
        this.template.save((Object)user.rate(hollywood, 4, "Pretty good"));
        this.template.save((Object)user2);
        this.template.clear();
        Filter nameFilter = new Filter("name", (Object)"Harmanpreet Singh");
        Filter middleNameFilter = new Filter("middleName", (Object)"A");
        middleNameFilter.setBooleanOperator(BooleanOperator.AND);
        Filters filters = new Filters();
        filters.add(new Filter[]{nameFilter, middleNameFilter});
        Collection u = this.template.loadAllByProperties(User.class, filters, 0);
        Assert.assertEquals((long)2L, (long)u.size());
        Assert.assertEquals((long)0L, (long)((User)u.iterator().next()).getRatings().size());
        u = this.template.loadAllByProperties(User.class, filters, 2);
        Assert.assertEquals((long)2L, (long)u.size());
        Assert.assertNotNull(((User)u.iterator().next()).getRatings().iterator().next().getMovie().getRatings());
    }

    @Test
    public void shouldExecuteArbitraryUpdateQuery() {
        Assert.assertTrue((String)"There shouldn't be any genres in the database", (boolean)this.template.loadAll(Genre.class).isEmpty());
        this.template.query("CREATE (:Genre {name:'Comedy'}), (:Genre {name:'Action'})", Collections.EMPTY_MAP);
        Iterator genres = this.template.loadAll(Genre.class, 0).iterator();
        Assert.assertEquals((String)"There weren't any genres created", (long)2L, (long)Utils.size(genres));
    }

    @Test(expected=RuntimeException.class)
    @Ignore
    public void shouldThrowExceptionForExecuteQueryThatReturnsResults() {
        this.template.query("CREATE (g1:Genre {name:'Comedy'}), (g2:Genre {name:'Action'}) return g1", Collections.EMPTY_MAP);
    }

    @Test
    public void shouldCountNumberOfEntitiesOfParticularTypeInGraphDatabase() {
        GraphDatabaseService database = this.graphDatabaseService;
        try (Transaction tx = database.beginTx();){
            Label genreTypeLabel = DynamicLabel.label((String)Genre.class.getSimpleName());
            for (int i = 0; i < 5; ++i) {
                database.createNode(new Label[]{genreTypeLabel});
            }
            Label filmTypeLabel = DynamicLabel.label((String)TempMovie.class.getAnnotation(NodeEntity.class).label());
            for (int i = 0; i < 3; ++i) {
                database.createNode(new Label[]{filmTypeLabel});
            }
            database.createNode(new Label[]{DynamicLabel.label((String)User.class.getSimpleName())});
            tx.success();
        }
        Assert.assertEquals((long)5L, (long)this.template.count(Genre.class));
        Assert.assertEquals((long)3L, (long)this.template.count(TempMovie.class));
    }

    @Test
    public void shouldDeleteExistingEntitiesByGraphId() {
        Long genreId = (Long)this.graphDatabaseService.execute("CREATE (t:Genre {name:'Thriller'}), (r:Genre {name:'RomCom'}) RETURN id(r) AS gid").columnAs("gid").next();
        Genre entity = (Genre)this.template.load(Genre.class, genreId);
        Assert.assertEquals((Object)"RomCom", (Object)entity.getName());
        this.template.delete((Object)entity);
        Collection allGenres = this.template.loadAll(Genre.class, 0);
        Assert.assertEquals((String)"The genre wasn't deleted", (long)1L, (long)allGenres.size());
        Assert.assertEquals((String)"The wrong genre was deleted", (Object)"Thriller", (Object)((Genre)allGenres.iterator().next()).getName());
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    public void shouldConvertOGMExceptionsToPersistenceExceptions() {
        this.template.loadAll(Rating.class, 0);
    }

    @Test(expected=Exception.class)
    public void shouldHandleErrorsOnExecute() {
        this.template.query("CREAT (node:NODE)", Collections.EMPTY_MAP);
    }

    @Test
    public void shouldReturnQueryStats() {
        QueryStatistics stats = this.template.query("CREATE (a:Actor {name:'Keanu Reeves'}) CREATE (m:Movie {title:'The Matrix'}) CREATE (a)-[:ACTED_IN {role:'Neo'}]->(m)", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertEquals((long)2L, (long)stats.getNodesCreated());
        Assert.assertEquals((long)3L, (long)stats.getPropertiesSet());
        Assert.assertEquals((long)1L, (long)stats.getRelationshipsCreated());
        Assert.assertEquals((long)2L, (long)stats.getLabelsAdded());
        stats = this.template.query("MATCH (a:Actor)-->(m:Movie) REMOVE a:Actor SET m.title=null", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertTrue((boolean)stats.containsUpdates());
        Assert.assertEquals((long)1L, (long)stats.getLabelsRemoved());
        Assert.assertEquals((long)1L, (long)stats.getPropertiesSet());
        stats = this.template.query("MATCH n-[r]-(m:Movie) delete n,r,m", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertTrue((boolean)stats.containsUpdates());
        Assert.assertEquals((long)2L, (long)stats.getNodesDeleted());
        Assert.assertEquals((long)1L, (long)stats.getRelationshipsDeleted());
    }

    @Test
    public void shouldReturnSchemaQueryStats() {
        QueryStatistics stats = this.template.query("CREATE INDEX ON :Actor(name)", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertEquals((long)1L, (long)stats.getIndexesAdded());
        stats = this.template.query("CREATE CONSTRAINT ON (movie:Movie) ASSERT movie.title IS UNIQUE", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertEquals((long)1L, (long)stats.getConstraintsAdded());
        stats = this.template.query("DROP CONSTRAINT ON (movie:Movie) ASSERT movie.title is UNIQUE", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertEquals((long)1L, (long)stats.getConstraintsRemoved());
        stats = this.template.query("DROP INDEX ON :Actor(name)", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertEquals((long)1L, (long)stats.getIndexesRemoved());
    }

    @Test
    public void shouldReturnQueryStatsForQueryWithParams() {
        QueryStatistics stats = this.template.execute("CREATE (a:Actor {name:{actorName}}) CREATE (m:Movie {title:{movieTitle}}) CREATE (a)-[:ACTED_IN {role:'Neo'}]->(m)", Utils.map((Object[])new Object[]{"actorName", "Keanu Reeves", "movieTitle", "THe Matrix"}));
        Assert.assertTrue((boolean)stats.containsUpdates());
        Assert.assertEquals((long)2L, (long)stats.getNodesCreated());
        Assert.assertEquals((long)3L, (long)stats.getPropertiesSet());
        Assert.assertEquals((long)1L, (long)stats.getRelationshipsCreated());
        Assert.assertEquals((long)2L, (long)stats.getLabelsAdded());
        stats = this.template.execute("MATCH (a:Actor)-->(m:Movie) REMOVE a:Actor SET m.title=null");
        Assert.assertTrue((boolean)stats.containsUpdates());
        Assert.assertEquals((long)1L, (long)stats.getLabelsRemoved());
        Assert.assertEquals((long)1L, (long)stats.getPropertiesSet());
        stats = this.template.query("MATCH n-[r]-(m:Movie) delete n,r,m", Collections.EMPTY_MAP).queryStatistics();
        Assert.assertTrue((boolean)stats.containsUpdates());
        Assert.assertEquals((long)2L, (long)stats.getNodesDeleted());
        Assert.assertEquals((long)1L, (long)stats.getRelationshipsDeleted());
    }

    @Test
    public void shouldRetrieveEntitiesByMatchingProperties() {
        this.template.save((Object)new Cinema("Ritzy", 5000));
        this.template.save((Object)new Cinema("Picturehouse", 7500));
        Filter name = new Filter("name", (Object)"Ritzy");
        Cinema loadedCinema = (Cinema)this.template.loadByProperties(Cinema.class, new Filters().add(new Filter[]{name}));
        Assert.assertNotNull((String)"No cinema was loaded", (Object)loadedCinema);
        Assert.assertEquals((Object)"Ritzy", (Object)loadedCinema.getName());
        Filter capacity = new Filter("capacity", (Object)1000);
        capacity.setComparisonOperator(ComparisonOperator.GREATER_THAN);
        Collection loadedCinemas = this.template.loadAllByProperties(Cinema.class, new Filters().add(new Filter[]{capacity}));
        Assert.assertNotNull((Object)loadedCinemas);
        Assert.assertEquals((long)2L, (long)loadedCinemas.size());
        Assert.assertTrue((boolean)loadedCinemas.contains(new Cinema("Ritzy", 5000)));
        Assert.assertTrue((boolean)loadedCinemas.contains(new Cinema("Picturehouse", 7500)));
    }

    @Test
    public void shouldAllowResultsToBeReturnedFromModifyingQueries() {
        Result results = this.template.query("CREATE (a:Actor {name:{actorName}}) CREATE (m:Movie {title:{movieTitle}}) CREATE (a)-[:ACTED_IN {role:'Neo'}]->(m) return a.name as actorName, m.title as movieName", Utils.map((Object[])new Object[]{"actorName", "Keanu Reeves", "movieTitle", "The Matrix"}));
        QueryStatistics stats = results.queryStatistics();
        Assert.assertEquals((long)2L, (long)stats.getNodesCreated());
        Assert.assertEquals((long)3L, (long)stats.getPropertiesSet());
        Assert.assertEquals((long)1L, (long)stats.getRelationshipsCreated());
        Assert.assertEquals((long)2L, (long)stats.getLabelsAdded());
        Iterable iterableResults = (Iterable)results.queryResults();
        Assert.assertNotNull((Object)iterableResults);
        for (Map row : iterableResults) {
            Assert.assertEquals((Object)"Keanu Reeves", row.get("actorName"));
            Assert.assertEquals((Object)"The Matrix", row.get("movieName"));
        }
    }
}

