/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transactions.service;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.template.Neo4jTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BusinessService {
    private static final Logger log = LoggerFactory.getLogger(BusinessService.class);
    @Autowired
    private Session session;

    @Transactional
    public void successMethod() {
        this.insertNode();
    }

    @Transactional
    public void failMethod() {
        this.insertNode();
        throw new RuntimeException("Deliberate to force rollback of entire transaction");
    }

    private void insertNode() {
        new Neo4jTemplate(this.session).execute("CREATE (node {name: 'n'})");
    }

    public Iterable<Map<String, Object>> loadNodes() {
        return new Neo4jTemplate(this.session).query("MATCH n RETURN n.name", new HashMap());
    }

    public void purge() {
        new Neo4jTemplate(this.session).execute("MATCH n DELETE n");
    }
}

