/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transactions.service;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.transactions.service.BusinessService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WrapperService {
    private static final Logger log = LoggerFactory.getLogger(BusinessService.class);
    @Autowired
    BusinessService businessService;

    @Transactional
    public void composeSuccessThenFail() {
        this.businessService.successMethod();
        this.businessService.failMethod();
    }

    @Transactional
    public void composeSuccessThenSuccess() {
        this.businessService.successMethod();
        this.businessService.successMethod();
    }

    @Transactional
    public void composeFailThenSuccess() {
        this.businessService.failMethod();
        this.businessService.successMethod();
    }

    @Transactional
    public void composeFailThenFail() {
        this.businessService.failMethod();
        this.businessService.failMethod();
    }

    public Iterable<Map<String, Object>> loadNodes() {
        return this.businessService.loadNodes();
    }

    public void purge() {
        this.businessService.purge();
    }
}

