/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.galaxy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.examples.galaxy.context.GalaxyContext;
import org.springframework.data.neo4j.examples.galaxy.domain.World;
import org.springframework.data.neo4j.examples.galaxy.service.GalaxyService;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@ContextConfiguration(classes={GalaxyContext.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@Transactional
@DirtiesContext
public class GalaxyServiceTest
extends MultiDriverTestClass {
    @Autowired
    private GalaxyService galaxyService;

    @Before
    public void setUp() {
        this.galaxyService.deleteAll();
        Assert.assertEquals((long)0L, (long)this.galaxyService.getNumberOfWorlds());
    }

    @Test
    public void shouldAllowDirectWorldCreation() {
        World myWorld = this.galaxyService.createWorld("mine", 0);
        Collection foundWorlds = (Collection)this.galaxyService.getAllWorlds();
        Assert.assertEquals((long)1L, (long)foundWorlds.size());
        World mine = (World)foundWorlds.iterator().next();
        Assert.assertEquals((Object)myWorld.getName(), (Object)mine.getName());
    }

    @Test
    public void shouldHaveCorrectNumberOfWorlds() {
        this.galaxyService.makeSomeWorlds();
        Assert.assertEquals((long)13L, (long)this.galaxyService.getNumberOfWorlds());
    }

    @Test
    public void createAllWorldsAtOnce() {
        this.galaxyService.makeAllWorldsAtOnce();
        Assert.assertEquals((long)13L, (long)this.galaxyService.getNumberOfWorlds());
        World earth = this.galaxyService.findWorldByName("Earth");
        World mars = this.galaxyService.findWorldByName("Mars");
        Assert.assertTrue((boolean)mars.canBeReachedFrom(earth));
        Assert.assertTrue((boolean)earth.canBeReachedFrom(mars));
    }

    @Test
    public void shouldFindWorldsById() {
        this.galaxyService.makeSomeWorlds();
        for (World world : this.galaxyService.getAllWorlds()) {
            World foundWorld = this.galaxyService.findWorldById(world.getId());
            Assert.assertNotNull((Object)foundWorld);
        }
    }

    @Test
    public void shouldFindWorldsByName() {
        this.galaxyService.makeSomeWorlds();
        for (World world : this.galaxyService.getAllWorlds()) {
            World foundWorld = this.galaxyService.findWorldByName(world.getName());
            Assert.assertNotNull((Object)foundWorld);
        }
    }

    @Test
    public void shouldReachMarsFromEarth() {
        this.galaxyService.makeSomeWorlds();
        World earth = this.galaxyService.findWorldByName("Earth");
        World mars = this.galaxyService.findWorldByName("Mars");
        Assert.assertTrue((boolean)mars.canBeReachedFrom(earth));
        Assert.assertTrue((boolean)earth.canBeReachedFrom(mars));
    }

    @Test
    public void shouldFindAllWorlds() {
        Collection<World> madeWorlds = this.galaxyService.makeSomeWorlds();
        Iterable<World> foundWorlds = this.galaxyService.getAllWorlds();
        int countOfFoundWorlds = 0;
        for (World foundWorld : foundWorlds) {
            Assert.assertTrue((boolean)madeWorlds.contains(foundWorld));
            ++countOfFoundWorlds;
        }
        Assert.assertEquals((long)madeWorlds.size(), (long)countOfFoundWorlds);
    }

    @Test
    public void shouldFindWorldsWith1Moon() {
        this.galaxyService.makeSomeWorlds();
        for (World worldWithOneMoon : this.galaxyService.findAllByNumberOfMoons(1)) {
            Assert.assertThat((Object)worldWithOneMoon.getName(), (Matcher)Is.is((Matcher)AnyOf.anyOf((Matcher)StringContains.containsString((String)"Earth"), (Matcher)StringContains.containsString((String)"Midgard"))));
        }
    }

    @Test
    public void shouldNotFindKrypton() {
        this.galaxyService.makeSomeWorlds();
        World krypton = this.galaxyService.findWorldByName("Krypton");
        Assert.assertNull((Object)krypton);
    }

    @Test
    public void shouldSupportPaging() {
        List worlds = (List)this.galaxyService.makeAllWorldsAtOnce();
        int count = worlds.size();
        int PAGE_SIZE = 3;
        int pages = count / PAGE_SIZE + 1;
        long n = 0L;
        for (World world : worlds) {
            n += world.getId().longValue();
        }
        for (int page = 0; page < pages; ++page) {
            Iterable<World> paged = this.galaxyService.findAllWorlds(new Pagination(page, PAGE_SIZE));
            for (World world : paged) {
                System.out.println(world.getName() + ":" + world.getId());
                n -= world.getId().longValue();
            }
        }
        Assert.assertEquals((long)0L, (long)n);
    }

    @Test
    public void shouldDetectNotOnLastPage() {
        int count = this.galaxyService.makeAllWorldsAtOnce().size();
        Assert.assertEquals((long)count, (long)13L);
        PageRequest pageable = new PageRequest(2, 3);
        Page<World> worlds = this.galaxyService.findAllWorlds((Pageable)pageable);
        for (World world : worlds) {
            System.out.println(world.getName() + ": " + world.getId());
        }
        Assert.assertTrue((boolean)worlds.hasNext());
    }

    @Test
    public void shouldDetectLastPage() {
        int count = this.galaxyService.makeAllWorldsAtOnce().size();
        Assert.assertEquals((long)count, (long)13L);
        PageRequest pageable = new PageRequest(4, 3);
        Page<World> worlds = this.galaxyService.findAllWorlds((Pageable)pageable);
        for (World world : worlds) {
            System.out.println(world.getName() + ": " + world.getId());
        }
        Assert.assertFalse((boolean)worlds.hasNext());
    }

    @Test
    public void shouldPageAllWorlds() {
        long sum = 0L;
        List worlds = (List)this.galaxyService.makeAllWorldsAtOnce();
        for (World world : worlds) {
            sum += world.getId().longValue();
        }
        PageRequest pageable = new PageRequest(0, 3);
        while (true) {
            Page<World> page = this.galaxyService.findAllWorlds((Pageable)pageable);
            for (World world : page) {
                System.out.println(world.getName() + ":" + world.getId());
                sum -= world.getId().longValue();
            }
            if (!page.hasNext()) break;
            pageable = pageable.next();
        }
        Assert.assertEquals((long)0L, (long)sum);
    }

    @Test
    public void shouldPageAllWorldsSorted() {
        List worlds = (List)this.galaxyService.makeAllWorldsAtOnce();
        int count = worlds.size();
        Assert.assertEquals((long)count, (long)13L);
        String[] sortedNames = this.getNamesSorted(worlds);
        PageRequest pageable = new PageRequest(0, 3, Sort.Direction.ASC, new String[]{"name"});
        int i = 0;
        while (true) {
            Page<World> page = this.galaxyService.findAllWorlds((Pageable)pageable);
            for (World world : page) {
                Assert.assertEquals((Object)sortedNames[i], (Object)world.getName());
                --count;
                ++i;
            }
            if (!page.hasNext()) break;
            pageable = pageable.next();
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void shouldIterateAllWorldsSorted() {
        List worlds = (List)this.galaxyService.makeAllWorldsAtOnce();
        int count = worlds.size();
        Assert.assertEquals((long)count, (long)13L);
        String[] sortedNames = this.getNamesSorted(worlds);
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"name"});
        int i = 0;
        for (World world : this.galaxyService.findAllWorlds(sort)) {
            Assert.assertEquals((Object)sortedNames[i], (Object)world.getName());
            --count;
            ++i;
        }
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void shouldFindWorldWithRadius() {
        this.galaxyService.deleteAll();
        World earth = new World("Earth", 1);
        earth.setRadius(Float.valueOf(6371.0f));
        this.galaxyService.create(earth);
        earth = this.galaxyService.findByName("Earth");
        Assert.assertEquals((Object)Float.valueOf(6371.0f), (Object)earth.getRadius());
    }

    private String[] getNamesSorted(List<World> worlds) {
        ArrayList<String> names = new ArrayList<String>();
        for (World world : worlds) {
            names.add(world.getName());
        }
        Object[] sortedNames = names.toArray(new String[0]);
        Arrays.sort(sortedNames);
        return sortedNames;
    }
}

