/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.galaxy.domain;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.Relationship;

public class World {
    private static final String REACHABLE_BY_ROCKET = "REACHABLE_BY_ROCKET";
    private Long id;
    private String name;
    private int moons;
    private Float radius;
    private Long updated;
    private Set<World> reachableByRocket = new HashSet<World>();

    public Long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public World(String name, int moons) {
        this.name = name;
        this.moons = moons;
    }

    public World() {
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getMoons() {
        return this.moons;
    }

    public void addRocketRouteTo(World otherWorld) {
        this.reachableByRocket.add(otherWorld);
        otherWorld.reachableByRocket.add(this);
    }

    @Relationship(type="REACHABLE_BY_ROCKET", direction="UNDIRECTED")
    public Set<World> getReachableByRocket() {
        return this.reachableByRocket;
    }

    @Relationship(type="REACHABLE_BY_ROCKET", direction="UNDIRECTED")
    public void setReachableByRocket(Set<World> reachableByRocket) {
        this.reachableByRocket.clear();
        this.reachableByRocket = reachableByRocket;
    }

    public boolean canBeReachedFrom(World otherWorld) {
        for (World world : this.reachableByRocket) {
            if (!world.equals(otherWorld)) continue;
            return true;
        }
        return false;
    }

    public Float getRadius() {
        return this.radius;
    }

    public void setRadius(Float radius) {
        this.radius = radius;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        World world = (World)o;
        if (this.moons != world.moons) {
            return false;
        }
        if (this.id != null ? !this.id.equals(world.id) : world.id != null) {
            return false;
        }
        return !(this.name == null ? world.name != null : !this.name.equals(world.name));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.moons;
        return result;
    }

    public String toString() {
        return String.format("World{name='%s', moons=%d}", this.name, this.moons);
    }
}

