/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.examples.movies.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.examples.movies.domain.Genre;
import org.springframework.data.neo4j.examples.movies.domain.User;
import org.springframework.data.neo4j.examples.movies.repo.GenreRepository;
import org.springframework.data.neo4j.examples.movies.repo.UserRepository;
import org.springframework.data.neo4j.examples.movies.service.UserService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GenreRepository genreRepository;

    @Override
    public void updateUser(User user, String newName) {
        user.setName(newName);
    }

    @Override
    public void notInterestedIn(Long userId, Long genreId) {
        User user = (User)this.userRepository.findOne(userId);
        Genre genre = (Genre)this.genreRepository.findOne(genreId);
        user.notInterestedIn(genre);
        this.userRepository.save(user);
    }

    @Override
    public void saveWithTxAnnotationOnInterface(User user) {
        this.userRepository.save(user);
    }

    @Override
    @Transactional
    public void saveWithTxAnnotationOnImpl(User user) {
        this.userRepository.save(user);
    }
}

