/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repositories;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.data.neo4j.repositories.domain.Movie;
import org.springframework.data.neo4j.repositories.domain.User;
import org.springframework.data.neo4j.repositories.repo.MovieRepository;
import org.springframework.data.neo4j.repositories.repo.UserRepository;
import org.springframework.data.neo4j.repository.support.GraphRepositoryFactory;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.data.neo4j.template.Neo4jTemplate;
import org.springframework.data.neo4j.util.IterableUtils;

public class ProgrammaticRepositoryTest
extends MultiDriverTestClass {
    private MovieRepository movieRepository;
    private SessionFactory sessionFactory = new SessionFactory(new String[]{"org.springframework.data.neo4j.repositories.domain"});
    private Session session;
    private Neo4jOperations neo4jOperations;

    @Before
    public void init() {
        this.session = this.sessionFactory.openSession();
        this.neo4jOperations = new Neo4jTemplate(this.session);
        this.session.purgeDatabase();
    }

    @Test
    public void canInstantiateRepositoryProgrammatically() {
        GraphRepositoryFactory factory = new GraphRepositoryFactory(this.session, this.neo4jOperations);
        this.movieRepository = (MovieRepository)factory.getRepository(MovieRepository.class);
        Movie movie = new Movie("PF");
        this.movieRepository.save(movie);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ProgrammaticRepositoryTest.getGraphDatabaseService(), (String)"CREATE (m:Movie {title:'PF'})");
        Assert.assertEquals((long)1L, (long)IterableUtils.count(this.movieRepository.findAll()));
    }

    @Test
    public void shouldBeAbleToDeleteAllViaRepository() {
        GraphRepositoryFactory factory = new GraphRepositoryFactory(this.session, this.neo4jOperations);
        UserRepository userRepository = (UserRepository)factory.getRepository(UserRepository.class);
        User userA = new User("A");
        User userB = new User("B");
        userRepository.save(userA);
        userRepository.save(userB);
        Assert.assertEquals((long)2L, (long)userRepository.count());
        userRepository.deleteAll();
        Assert.assertEquals((long)0L, (long)userRepository.count());
    }
}

