/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.web;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.web.context.WebAppContext;
import org.springframework.data.neo4j.web.context.WebPersistenceContext;
import org.springframework.data.neo4j.web.domain.User;
import org.springframework.data.neo4j.web.repo.UserRepository;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@ContextConfiguration(classes={WebAppContext.class, WebPersistenceContext.class})
@WebAppConfiguration
@RunWith(value=SpringJUnit4ClassRunner.class)
public class WebIntegrationTest
extends MultiDriverTestClass {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private WebApplicationContext wac;
    @Autowired
    private Session session;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        this.session.purgeDatabase();
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.wac).build();
        User adam = new User("Adam");
        User daniela = new User("Daniela");
        User michal = new User("Michal");
        User vince = new User("Vince");
        adam.befriend(daniela);
        daniela.befriend(michal);
        michal.befriend(vince);
        this.userRepository.save(adam);
    }

    @Test
    public void shouldNotShareSessionBetweenRequestsWithDifferentSession() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/friends", (Object[])new Object[]{"Adam"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Daniela"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/friends", (Object[])new Object[]{"Vince"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Michal"));
    }

    @Test
    public void shouldShareSessionBetweenRequestsDuringSameSession() throws Exception {
        MockHttpSession session = new MockHttpSession();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/immediateFriends", (Object[])new Object[]{"Adam"}).session(session)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Daniela"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/immediateFriends", (Object[])new Object[]{"Daniela"}).session(session)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Adam Michal"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/immediateFriends", (Object[])new Object[]{"Michal"}).session(session)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Daniela Vince"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/immediateFriends", (Object[])new Object[]{"Vince"}).session(session)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Michal"));
    }

    @Test
    public void shouldNotShareSessionBetweenMultiThreadedRequests() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        int i = 0;
        while (i < 100) {
            final int j = i++;
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    if (j % 2 == 0) {
                        try {
                            WebIntegrationTest.this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/friends", (Object[])new Object[]{"Adam"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Daniela"));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        WebIntegrationTest.this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/user/{name}/friends", (Object[])new Object[]{"Vince"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("Michal"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
    }
}

