/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.config.oracle;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.ConnectionFactory;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jms.AQjmsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.data.jdbc.config.oracle.OracleConnectionProxy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.jdbc.support.nativejdbc.SimpleNativeJdbcExtractor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AqJmsFactoryBeanFactory
implements FactoryBean<ConnectionFactory> {
    protected static final Log logger = LogFactory.getLog(AqJmsFactoryBeanFactory.class);
    private ConnectionFactory aqConnectionFactory;
    private boolean coordinateWithDataSourceTransactions = false;
    private DataSource dataSource;
    private ConnectionFactoryType connectionFactoryType = ConnectionFactoryType.CONNECTION;
    private NativeJdbcExtractor nativeJdbcExtractor = new SimpleNativeJdbcExtractor();

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConnectionFactoryType(ConnectionFactoryType connectionFactoryType) {
        this.connectionFactoryType = connectionFactoryType;
    }

    public void setCoordinateWithDataSourceTransactions(boolean coordinateWithDataSourceTransactions) {
        this.coordinateWithDataSourceTransactions = coordinateWithDataSourceTransactions;
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public synchronized ConnectionFactory getObject() throws Exception {
        Object dataSourceToUse;
        if (this.coordinateWithDataSourceTransactions) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Enabling coordination of messaging transactions with data source transactions");
            }
            dataSourceToUse = new TransactionAwareDataSource(this.dataSource);
        } else {
            dataSourceToUse = this.dataSource;
        }
        if (this.aqConnectionFactory == null) {
            if (this.connectionFactoryType == ConnectionFactoryType.CONNECTION) {
                logger.debug((Object)"Using a 'ConnectionFactory' as the AQ Connection Factory");
                this.aqConnectionFactory = AQjmsFactory.getConnectionFactory((DataSource)dataSourceToUse);
            }
            if (this.connectionFactoryType == ConnectionFactoryType.QUEUE_CONNECTION) {
                logger.debug((Object)"Using a 'QueueConnectionFactory' as the AQ Connection Factory");
                this.aqConnectionFactory = AQjmsFactory.getQueueConnectionFactory((DataSource)dataSourceToUse);
            }
            if (this.connectionFactoryType == ConnectionFactoryType.TOPIC_CONNECTION) {
                logger.debug((Object)"Using a 'TopicConnectionFactory' as the AQ Connection Factory");
                this.aqConnectionFactory = AQjmsFactory.getTopicConnectionFactory((DataSource)dataSourceToUse);
            }
        }
        return this.aqConnectionFactory;
    }

    public Class<? extends ConnectionFactory> getObjectType() {
        return ConnectionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(OracleConnectionProxy.class.getClassLoader(), new Class[]{OracleConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    protected Connection getCloseDelegatingConnectionProxy(Connection target, Connection source) {
        return (Connection)Proxy.newProxyInstance(OracleConnectionProxy.class.getClassLoader(), new Class[]{OracleConnectionProxy.class}, (InvocationHandler)new CloseDelegatingInvocationHandler(target, source));
    }

    private static class CloseDelegatingInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final Connection source;

        public CloseDelegatingInvocationHandler(Connection target, Connection source) {
            this.target = target;
            this.source = source;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Calling close for Connection [" + this.target + "] on source [" + this.source + "]"));
                }
                this.source.close();
                return null;
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Coordinating transaction management for Connection [" + this.target + "]"));
                }
                return null;
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private class TransactionAwareDataSource
    extends DelegatingDataSource {
        public TransactionAwareDataSource(DataSource dataSource) {
            super(dataSource);
        }

        public Connection getConnection() throws SQLException {
            Connection con;
            Connection conToUse = con = DataSourceUtils.getConnection((DataSource)this.getTargetDataSource());
            if (!(con instanceof OracleConnection)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unwrapping JDBC Connection of type:" + con.getClass().getName()));
                }
                try {
                    conToUse = AqJmsFactoryBeanFactory.this.nativeJdbcExtractor.getNativeConnection(con);
                }
                catch (SQLException e) {
                    throw new NonTransientDataAccessResourceException("Error unwrapping the Oracle Connection: " + e.getMessage(), (Throwable)e);
                }
            }
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using Proxied JDBC Connection [" + conToUse + "]"));
                }
                return AqJmsFactoryBeanFactory.this.getCloseSuppressingConnectionProxy(conToUse);
            }
            if (con instanceof OracleConnection) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using Native JDBC Connection [" + conToUse + "]"));
                }
                return conToUse;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using Closeable Proxy fo JDBC Connection [" + conToUse + "]"));
            }
            return AqJmsFactoryBeanFactory.this.getCloseDelegatingConnectionProxy(conToUse, con);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionFactoryType {
        CONNECTION,
        QUEUE_CONNECTION,
        TOPIC_CONNECTION;

    }
}

