/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.jms.support.converter.oracle;

import java.sql.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsSession;
import oracle.jms.AdtMessage;
import oracle.sql.ORAData;
import oracle.xdb.XMLType;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.jdbc.support.oracle.XmlTypeHandler;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class XmlMessageConverter
implements MessageConverter {
    private XmlTypeHandler handler;

    public XmlMessageConverter(XmlTypeHandler handler) {
        this.handler = handler;
    }

    protected XmlTypeHandler getHandler() {
        return this.handler;
    }

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        AdtMessage message = ((AQjmsSession)session).createAdtMessage();
        Connection conn = ((AQjmsSession)session).getDBConnection();
        XMLType xml = null;
        try {
            xml = this.handler.createXmlType(object, conn);
        }
        catch (DataRetrievalFailureException e) {
            throw new MessageConversionException("Error while creating XML message", (Throwable)e);
        }
        message.setAdtPayload((ORAData)xml);
        return message;
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        AQjmsAdtMessage aqMessage = (AQjmsAdtMessage)message;
        Object payload = aqMessage.getAdtPayload();
        if (payload instanceof XMLType) {
            try {
                return this.handler.getXmlContent((XMLType)payload);
            }
            catch (DataRetrievalFailureException e) {
                throw new MessageConversionException("Error while processing XML payload", (Throwable)e);
            }
        }
        throw new MessageConversionException("Payload is not an XMLType: " + payload.getClass().getName());
    }
}

