/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.retry.oracle;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jdbc.retry.JdbcRetryException;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RacRetryOperationsInterceptor
extends RetryOperationsInterceptor {
    private static final Log logger = LogFactory.getLog(RacRetryOperationsInterceptor.class);
    private static final ThreadLocal<MethodInvocation> activeRacRetry = new ThreadLocal();

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        if (activeRacRetry.get() == null) {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                throw new JdbcRetryException("An active transaction was found.  This is not allowed when starting a retryable operation.");
            }
            RacRetryOperationsInterceptor.startRacRetryInterception(methodInvocation);
            result = super.invoke(methodInvocation);
            RacRetryOperationsInterceptor.clearRacRetryInterception();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Participating in existing RAC Retry Interceptor");
            }
            result = methodInvocation.proceed();
        }
        return result;
    }

    public static boolean isRacRetryInterceptionActive() {
        return activeRacRetry.get() != null;
    }

    protected static void startRacRetryInterception(MethodInvocation methodInvocation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting a new RAC Retry Interceptor for " + (methodInvocation != null ? methodInvocation.getMethod() : null)));
        }
        activeRacRetry.set(methodInvocation);
    }

    protected static void clearRacRetryInterception() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Clearing RAC Retry Interceptor");
        }
        activeRacRetry.remove();
    }
}

