/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import oracle.xdb.XMLType;
import org.springframework.jdbc.support.xml.SqlXmlValue;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.MarshallingFailureException;

public class OracleXmlTypeMarshallingValue
implements SqlXmlValue {
    private Object value;
    private Marshaller marshaller;
    private XMLType xmlValue;

    public OracleXmlTypeMarshallingValue(Object value, Marshaller marshaller) {
        this.value = value;
        this.marshaller = marshaller;
    }

    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        Connection conn = ps.getConnection();
        StreamResult result = new StreamResult();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        result.setOutputStream(os);
        String stringValue = null;
        try {
            this.marshaller.marshal(this.value, (Result)result);
            stringValue = os.toString();
        }
        catch (IOException e) {
            throw new MarshallingFailureException("Error marshalling xml data from object " + this.value.getClass().getName() + ": ");
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ignore) {}
        }
        this.xmlValue = new XMLType(conn, stringValue);
        ps.setObject(paramIndex, (Object)this.xmlValue, 2007);
    }

    public void cleanup() {
        if (this.xmlValue != null) {
            this.xmlValue.close();
        }
    }
}

