/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.data.jdbc.support.ConnectionContextProvider;
import org.springframework.data.jdbc.support.ConnectionPreparer;
import org.springframework.data.jdbc.support.ConnectionUsernamePasswordProvider;
import org.springframework.data.jdbc.support.ConnectionUsernameProvider;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.Assert;

public class ProxyConnectionPreparer
implements ConnectionPreparer {
    private ConnectionContextProvider contextProvider;
    NativeJdbcExtractor jdbcExtractor;

    public void setContextProvider(ConnectionContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public void setJdbcExtractor(NativeJdbcExtractor jdbcExtractor) {
        this.jdbcExtractor = jdbcExtractor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection prepare(Connection connection) {
        OracleConnection oraCon;
        Assert.notNull((Object)this.contextProvider, (String)"You must provide a ConnectionContextProvider implementation that provides the username");
        if (!(this.contextProvider instanceof ConnectionUsernamePasswordProvider) && !(this.contextProvider instanceof ConnectionUsernameProvider)) throw new InvalidDataAccessApiUsageException("The provided ContextProvider must implement one of the CurrenUsernameProvider or CurrentUsernamePasswordProvider interfaces");
        if (connection instanceof OracleConnection) {
            oraCon = (OracleConnection)connection;
        } else {
            if (this.jdbcExtractor == null) throw new NonTransientDataAccessResourceException("Provided connection is not of type OracleConnection and no NativeJdbcExtractor provided");
            try {
                Connection nativeCon = this.jdbcExtractor.getNativeConnection(connection);
                if (!(nativeCon instanceof OracleConnection)) {
                    throw new NonTransientDataAccessResourceException("Native connection is not of type OracleConnection");
                }
                oraCon = (OracleConnection)connection;
            }
            catch (SQLException e) {
                throw new NonTransientDataAccessResourceException("Unable to access native connection: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            return this.doPrepareUserNameProxyConnection((ConnectionUsernameProvider)this.contextProvider, oraCon);
        }
        catch (SQLException e) {
            System.out.println("!!! " + e);
            throw new NonTransientDataAccessResourceException("Unable to prepare user name proxy connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private Connection doPrepareUserNameProxyConnection(ConnectionUsernameProvider contextProvider, OracleConnection oraCon) throws SQLException {
        String proxyUserName = contextProvider.getUserName();
        String proxyPassword = null;
        if (contextProvider instanceof ConnectionUsernamePasswordProvider) {
            proxyPassword = ((ConnectionUsernamePasswordProvider)contextProvider).getPassword();
        }
        if (proxyUserName != null) {
            Properties proxyProperties = new Properties();
            proxyProperties.setProperty("PROXY_USER_NAME", proxyUserName);
            if (proxyPassword != null) {
                proxyProperties.setProperty("PROXY_USER_PASSWORD", proxyPassword);
            }
            oraCon.openProxySession(1, proxyProperties);
            return this.getUserNameConnectionProxyWrapper((Connection)oraCon);
        }
        return oraCon;
    }

    protected Connection getUserNameConnectionProxyWrapper(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new UserNameConnectionProxyInvocationHandler(target));
    }

    private static class UserNameConnectionProxyInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public UserNameConnectionProxyInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                if (this.target instanceof OracleConnection) {
                    ((OracleConnection)this.target).close(1);
                }
                this.target.close();
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

