/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.support.oracle.StructMapper;
import org.springframework.jdbc.core.support.AbstractSqlTypeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStructArrayValue<T>
extends AbstractSqlTypeValue {
    private T[] values;
    private StructMapper<T> mapper;
    private String structTypeName;
    private String arrayTypeName;

    public SqlStructArrayValue(T[] values, StructMapper<T> mapper, String structTypeName) {
        this.values = values;
        this.mapper = mapper;
        this.structTypeName = structTypeName;
    }

    public SqlStructArrayValue(T[] values, StructMapper<T> mapper, String structTypeName, String arrayTypeName) {
        this.values = values;
        this.mapper = mapper;
        this.structTypeName = structTypeName;
        this.arrayTypeName = arrayTypeName;
    }

    protected Object createTypeValue(Connection conn, int sqlType, String typeName) throws SQLException {
        if (typeName == null && this.arrayTypeName == null) {
            throw new InvalidDataAccessApiUsageException("The typeName for the array is null in this context. Consider setting the arrayTypeName.");
        }
        ArrayDescriptor arrayDescriptor = new ArrayDescriptor(typeName != null ? typeName : this.arrayTypeName, conn);
        STRUCT[] structValues = new STRUCT[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            structValues[i] = this.mapper.toStruct(this.values[i], conn, this.structTypeName);
        }
        ARRAY array = new ARRAY(arrayDescriptor, conn, (Object)structValues);
        return array;
    }
}

