/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.STRUCT;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.support.oracle.BeanPropertyStructMapper;
import org.springframework.data.jdbc.support.oracle.StructMapper;
import org.springframework.jdbc.core.support.AbstractSqlTypeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStructValue<T>
extends AbstractSqlTypeValue {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private T source;
    private StructMapper mapper;
    private String defaultTypeName;

    public SqlStructValue(T source) {
        this.source = source;
        this.mapper = new BeanPropertyStructMapper(source.getClass());
    }

    public SqlStructValue(T source, String defaultTypeName) {
        this.source = source;
        this.defaultTypeName = defaultTypeName;
    }

    public SqlStructValue(T source, StructMapper mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    public SqlStructValue(T source, StructMapper mapper, String defaultTypeName) {
        this.source = source;
        this.mapper = mapper;
        this.defaultTypeName = defaultTypeName;
    }

    protected Object createTypeValue(Connection conn, int sqlType, String typeName) throws SQLException {
        if (typeName == null && this.defaultTypeName == null) {
            throw new InvalidDataAccessApiUsageException("The typeName is null in this context. Consider setting the defaultTypeName.");
        }
        STRUCT struct = this.mapper.toStruct(this.source, conn, typeName != null ? typeName : this.defaultTypeName);
        return struct;
    }
}

