/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.beans.PropertyDescriptor;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.support.oracle.StructMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanPropertyStructMapper<T>
implements StructMapper<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Class<T> mappedClass;
    private Map<String, PropertyDescriptor> mappedFields;

    public BeanPropertyStructMapper() {
    }

    public BeanPropertyStructMapper(Class<T> mappedClass) {
        this.initialize(mappedClass);
    }

    public void setMappedClass(Class<T> mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (!this.mappedClass.equals(mappedClass)) {
            throw new InvalidDataAccessApiUsageException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    protected void initialize(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(mappedClass);
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(pd.getName().toLowerCase(), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (pd.getName().toLowerCase().equals(underscoredName)) continue;
            this.mappedFields.put(underscoredName, pd);
        }
    }

    private String underscoreName(String name) {
        StringBuffer result = new StringBuffer();
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toLowerCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase())) {
                    result.append("_");
                    result.append(s.toLowerCase());
                    continue;
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    public final Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public final Map<String, PropertyDescriptor> getMappedFields() {
        return this.mappedFields;
    }

    @Override
    public STRUCT toStruct(T source, Connection conn, String typeName) throws SQLException {
        StructDescriptor descriptor = new StructDescriptor(typeName, conn);
        ResultSetMetaData rsmd = descriptor.getMetaData();
        int columns = rsmd.getColumnCount();
        Object[] values = new Object[columns];
        for (int i = 1; i <= columns; ++i) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i).toLowerCase();
            PropertyDescriptor fieldMeta = this.mappedFields.get(column);
            if (fieldMeta == null) continue;
            BeanWrapperImpl bw = new BeanWrapperImpl(source);
            if (bw.isReadableProperty(fieldMeta.getName())) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Mapping column named \"" + column + "\"" + " to property \"" + fieldMeta.getName() + "\""));
                    }
                    values[i - 1] = bw.getPropertyValue(fieldMeta.getName());
                    continue;
                }
                catch (NotReadablePropertyException ex) {
                    throw new DataRetrievalFailureException("Unable to map column " + column + " to property " + fieldMeta.getName(), (Throwable)ex);
                }
            }
            this.logger.warn((Object)("Unable to access the getter for " + fieldMeta.getName() + ".  Check that " + "get" + StringUtils.capitalize((String)fieldMeta.getName()) + " is declared and has public access."));
        }
        STRUCT struct = new STRUCT(descriptor, conn, values);
        return struct;
    }

    @Override
    public T fromStruct(STRUCT struct) throws SQLException {
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        Object mappedObject = BeanUtils.instantiateClass(this.mappedClass);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)mappedObject);
        this.initBeanWrapper(bw);
        ResultSetMetaData rsmd = struct.getDescriptor().getMetaData();
        Object[] attr = struct.getAttributes();
        int columnCount = rsmd.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index).toLowerCase();
            PropertyDescriptor pd = this.mappedFields.get(column);
            if (pd == null) continue;
            try {
                Object value = attr[index - 1];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapping column '" + column + "' to property '" + pd.getName() + "' of type " + pd.getPropertyType()));
                }
                bw.setPropertyValue(pd.getName(), value);
                continue;
            }
            catch (NotWritablePropertyException ex) {
                throw new DataRetrievalFailureException("Unable to map column " + column + " to property " + pd.getName(), (Throwable)ex);
            }
        }
        return (T)mappedObject;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
    }

    public static <T> BeanPropertyStructMapper<T> newInstance(Class<T> mappedClass) {
        BeanPropertyStructMapper<T> newInstance = new BeanPropertyStructMapper<T>();
        newInstance.setMappedClass(mappedClass);
        return newInstance;
    }
}

