/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.config.oracle;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PoolingDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String DEFAULT_PROPERTY_FILE_LOCATION = "classpath:orcl.properties";
    private static final String DEFAULT_PROPERTY_PREFIX = null;
    private static final String DEFAULT_CONNECTION_CACHING_ENABLED = "true";
    private static final String CONNECTION_PROPERTIES_CHILD_ELEMENT = "connection-properties";
    private static final String CONNECTION_CACHE_PROPERTIES_CHILD_ELEMENT = "connection-cache-properties";
    private static final String USERNAME_CONNECTION_PROXY = "username-connection-proxy";
    private static final String CONNECTION_CONTEXT_PROVIDER = "connection-context-provider";
    private static final String PROPERTIES_LOCATION_ATTRIBUTE = "properties-location";
    private static final String CONNECTION_PROPERTIES_PREFIX_ATTRIBUTE = "connection-properties-prefix";
    private static final String CONNECTON_CACHE_PROPERTIS_PREFIX_ATTRIBUTE = "connection-cache-properties-prefix";
    private static final String URL_ATTRIBUTE = "url";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String PASSWORD_ATTRIBUTE = "password";
    private static final String ONS_CONFIGURATION_ATTRIBUTE = "ONS-configuration";
    private static final String FAST_CONNECTION_FAILOVER_ENABLED_ATTRIBUTE = "fast-connection-failover-enabled";
    private static final String CONNECTION_CACHING_ENABLED_ATTRIBUTE = "connection-caching-enabled";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<String, String> attributeToPropertyMap = new HashMap<String, String>();

    public PoolingDataSourceBeanDefinitionParser() {
        this.attributeToPropertyMap.put(URL_ATTRIBUTE, URL_ATTRIBUTE);
        this.attributeToPropertyMap.put(USERNAME_ATTRIBUTE, "user");
        this.attributeToPropertyMap.put(PASSWORD_ATTRIBUTE, PASSWORD_ATTRIBUTE);
        this.attributeToPropertyMap.put(CONNECTION_CACHING_ENABLED_ATTRIBUTE, "connectionCachingEnabled");
        this.attributeToPropertyMap.put(FAST_CONNECTION_FAILOVER_ENABLED_ATTRIBUTE, "fastConnectionFailoverEnabled");
        this.attributeToPropertyMap.put(ONS_CONFIGURATION_ATTRIBUTE, "ONSConfiguration");
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        boolean useWrapper = false;
        String connectionContextProviderRef = null;
        Element usernameConnectionProxyElement = DomUtils.getChildElementByTagName((Element)element, (String)USERNAME_CONNECTION_PROXY);
        if (usernameConnectionProxyElement != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using username-connection-proxy");
            }
            if (usernameConnectionProxyElement.hasAttribute(CONNECTION_CONTEXT_PROVIDER)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("connection-context-provider: " + usernameConnectionProxyElement.getAttribute(CONNECTION_CONTEXT_PROVIDER)));
                }
                connectionContextProviderRef = usernameConnectionProxyElement.getAttribute(CONNECTION_CONTEXT_PROVIDER);
            }
            useWrapper = true;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClassName(this.getBeanClassName(element));
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        builder.getRawBeanDefinition().setDestroyMethodName("close");
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        this.doParse(element, parserContext, builder);
        if (useWrapper) {
            BeanDefinitionBuilder wrapper = BeanDefinitionBuilder.genericBeanDefinition();
            wrapper.getRawBeanDefinition().setBeanClassName("org.springframework.data.jdbc.support.oracle.ProxyDataSource");
            wrapper.addConstructorArgValue((Object)builder.getBeanDefinition());
            if (connectionContextProviderRef == null) {
                wrapper.addConstructorArgValue(null);
            } else {
                wrapper.addConstructorArgReference(connectionContextProviderRef);
            }
            return wrapper.getBeanDefinition();
        }
        return builder.getBeanDefinition();
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        HashMap<String, Object> providedProperties;
        boolean propertyFileProvided;
        String connectionCachingEnabled;
        String fastConnectionFailoverEnabled;
        String onsConfiguration;
        String password;
        String username;
        String url;
        String cachingPropertyPrefix;
        String connectionPropertyPrefix;
        block28: {
            ResourceLoader rl = parserContext.getReaderContext().getResourceLoader();
            String propertyFileLocation = element.getAttribute(PROPERTIES_LOCATION_ATTRIBUTE);
            String connectionPropertyFileLocation = element.getAttribute(PROPERTIES_LOCATION_ATTRIBUTE);
            connectionPropertyPrefix = element.getAttribute(CONNECTION_PROPERTIES_PREFIX_ATTRIBUTE);
            cachingPropertyPrefix = element.getAttribute(CONNECTON_CACHE_PROPERTIS_PREFIX_ATTRIBUTE);
            url = element.getAttribute(URL_ATTRIBUTE);
            username = element.getAttribute(USERNAME_ATTRIBUTE);
            password = element.getAttribute(PASSWORD_ATTRIBUTE);
            onsConfiguration = element.getAttribute(ONS_CONFIGURATION_ATTRIBUTE);
            fastConnectionFailoverEnabled = element.getAttribute(FAST_CONNECTION_FAILOVER_ENABLED_ATTRIBUTE);
            connectionCachingEnabled = element.getAttribute(CONNECTION_CACHING_ENABLED_ATTRIBUTE);
            propertyFileProvided = false;
            providedProperties = new HashMap<String, Object>();
            if (!StringUtils.hasText((String)propertyFileLocation) && !StringUtils.hasText((String)connectionPropertyFileLocation)) {
                propertyFileLocation = DEFAULT_PROPERTY_FILE_LOCATION;
            }
            if (!StringUtils.hasText((String)connectionPropertyPrefix)) {
                connectionPropertyPrefix = DEFAULT_PROPERTY_PREFIX;
            }
            if (StringUtils.hasText((String)propertyFileLocation)) {
                this.logger.debug((Object)("Using properties location: " + propertyFileLocation));
                String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)propertyFileLocation);
                Resource r = rl.getResource(resolvedLocation);
                this.logger.debug((Object)("Loading properties from resource: " + r));
                PropertiesFactoryBean factoryBean = new PropertiesFactoryBean();
                factoryBean.setLocation(r);
                try {
                    factoryBean.afterPropertiesSet();
                    Properties resource = factoryBean.getObject();
                    for (Map.Entry<Object, Object> entry : resource.entrySet()) {
                        providedProperties.put((String)entry.getKey(), entry.getValue());
                    }
                    propertyFileProvided = true;
                }
                catch (FileNotFoundException e) {
                    propertyFileProvided = false;
                    if (propertyFileLocation.equals(DEFAULT_PROPERTY_FILE_LOCATION)) {
                        this.logger.debug((Object)("Unable to find " + propertyFileLocation));
                        break block28;
                    }
                    parserContext.getReaderContext().error("pooling-datasource defined with attribute 'properties-location' but the property file was not found at location \"" + propertyFileLocation + "\"", (Object)element);
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Error loading " + propertyFileLocation + ": " + e.getMessage()));
                }
            } else {
                propertyFileProvided = false;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using provided properties: " + providedProperties));
        }
        if (connectionPropertyPrefix == null) {
            connectionPropertyPrefix = "";
        }
        if (connectionPropertyPrefix.length() > 0 && !connectionPropertyPrefix.endsWith(".")) {
            connectionPropertyPrefix = connectionPropertyPrefix + ".";
        }
        this.logger.debug((Object)("Using connection properties prefix: " + connectionPropertyPrefix));
        if (cachingPropertyPrefix == null) {
            cachingPropertyPrefix = "";
        }
        if (cachingPropertyPrefix.length() > 0 && !cachingPropertyPrefix.endsWith(".")) {
            cachingPropertyPrefix = cachingPropertyPrefix + ".";
        }
        this.logger.debug((Object)("Using caching properties prefix: " + cachingPropertyPrefix));
        if (!StringUtils.hasText((String)connectionCachingEnabled) && !providedProperties.containsKey(this.attributeToPropertyMap.get(CONNECTION_CACHING_ENABLED_ATTRIBUTE))) {
            connectionCachingEnabled = DEFAULT_CONNECTION_CACHING_ENABLED;
        }
        this.setRequiredAttribute(builder, parserContext, element, providedProperties, connectionPropertyPrefix, propertyFileProvided, url, URL_ATTRIBUTE, "URL");
        this.setOptionalAttribute(builder, providedProperties, connectionPropertyPrefix, username, USERNAME_ATTRIBUTE);
        this.setOptionalAttribute(builder, providedProperties, connectionPropertyPrefix, password, PASSWORD_ATTRIBUTE);
        this.setOptionalAttribute(builder, providedProperties, connectionPropertyPrefix, connectionCachingEnabled, CONNECTION_CACHING_ENABLED_ATTRIBUTE);
        this.setOptionalAttribute(builder, providedProperties, connectionPropertyPrefix, fastConnectionFailoverEnabled, FAST_CONNECTION_FAILOVER_ENABLED_ATTRIBUTE);
        this.setOptionalAttribute(builder, providedProperties, connectionPropertyPrefix, onsConfiguration, ONS_CONFIGURATION_ATTRIBUTE);
        Properties providedConnectionProperties = new Properties();
        Properties providedCachingProperties = new Properties();
        for (String key : providedProperties.keySet()) {
            String newKey;
            if (StringUtils.hasText((String)connectionPropertyPrefix) && key.startsWith(connectionPropertyPrefix)) {
                newKey = key.substring(connectionPropertyPrefix.length());
                providedConnectionProperties.put(newKey, providedProperties.get(key));
                continue;
            }
            if (StringUtils.hasText((String)cachingPropertyPrefix) && key.startsWith(cachingPropertyPrefix)) {
                newKey = key.substring(cachingPropertyPrefix.length());
                providedCachingProperties.put(newKey, providedProperties.get(key));
                continue;
            }
            providedConnectionProperties.put(key, providedProperties.get(key));
        }
        String connProperties = DomUtils.getChildElementValueByTagName((Element)element, (String)CONNECTION_PROPERTIES_CHILD_ELEMENT);
        if (connProperties != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Using connection-properties");
            }
            builder.addPropertyValue("connectionProperties", (Object)connProperties);
        } else if (providedConnectionProperties.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using provided connection properties: " + providedConnectionProperties));
            }
            builder.addPropertyValue("connectionProperties", (Object)providedConnectionProperties);
        }
        String cacheProperties = DomUtils.getChildElementValueByTagName((Element)element, (String)CONNECTION_CACHE_PROPERTIES_CHILD_ELEMENT);
        if (cacheProperties != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using connection-cache-properties: [" + cacheProperties + "]"));
            }
            builder.addPropertyValue("connectionCacheProperties", (Object)cacheProperties);
        } else if (providedCachingProperties.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using provided caching properties: " + providedCachingProperties));
            }
            builder.addPropertyValue("connectionCacheProperties", (Object)providedCachingProperties);
        }
        builder.setRole(1);
    }

    protected String getBeanClassName(Element element) {
        return "oracle.jdbc.pool.OracleDataSource";
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    private void setRequiredAttribute(BeanDefinitionBuilder builder, ParserContext parserContext, Element element, Map<String, Object> providedProperties, String propertyPrefix, boolean propertyFileProvided, String attributeValue, String attributeName, String orclPropertyName) {
        String orclKey;
        String propertyToRemove = null;
        String propertyKey = propertyPrefix != null ? propertyPrefix + attributeName : attributeName;
        String string = orclKey = propertyPrefix != null ? propertyPrefix + orclPropertyName : orclPropertyName;
        if (StringUtils.hasText((String)attributeValue)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering required attribute " + orclPropertyName + " with attribute value " + attributeValue));
            }
            builder.addPropertyValue(orclPropertyName, (Object)attributeValue);
        } else if (providedProperties.containsKey(propertyKey) || providedProperties.containsKey(orclKey)) {
            Object value;
            if (providedProperties.containsKey(propertyKey)) {
                value = providedProperties.get(propertyKey);
                propertyToRemove = propertyKey;
            } else {
                value = providedProperties.get(orclKey);
                propertyToRemove = orclKey;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering required attribute " + orclPropertyName + " with property value " + value));
            }
            builder.addPropertyValue(orclPropertyName, value);
        } else if (propertyFileProvided) {
            parserContext.getReaderContext().error("pooling-datasource defined without the required '" + attributeName + "' attribute and the property file does not contain a \"" + this.attributeToPropertyMap.get(attributeName) + "\" entry", (Object)element);
        } else {
            parserContext.getReaderContext().error("pooling-datasource defined without the required '" + attributeName + "' attribute and a property file was not found at location \"" + DEFAULT_PROPERTY_FILE_LOCATION + "\"", (Object)element);
        }
        if (propertyToRemove != null) {
            this.removeProvidedProperty(providedProperties, propertyToRemove);
        }
    }

    private void setOptionalAttribute(BeanDefinitionBuilder builder, Map<String, Object> providedProperties, String propertyPrefix, String attributeValue, String attributeName) {
        String propertyKey;
        if (USERNAME_ATTRIBUTE.equals(attributeName)) {
            String userKey;
            String string = userKey = propertyPrefix != null ? propertyPrefix + "user" : "user";
            propertyKey = providedProperties.containsKey(userKey) ? userKey : (propertyPrefix != null ? propertyPrefix + attributeName : attributeName);
        } else {
            String string = propertyKey = propertyPrefix != null ? propertyPrefix + this.attributeToPropertyMap.get(attributeName) : this.attributeToPropertyMap.get(attributeName);
        }
        if (StringUtils.hasText((String)attributeValue)) {
            if (this.logger.isDebugEnabled()) {
                if (PASSWORD_ATTRIBUTE.equals(attributeName)) {
                    this.logger.debug((Object)("Registering optional attribute " + this.attributeToPropertyMap.get(attributeName) + " with attribute value ******"));
                } else {
                    this.logger.debug((Object)("Registering optional attribute " + this.attributeToPropertyMap.get(attributeName) + " with attribute value " + attributeValue));
                }
            }
            builder.addPropertyValue(this.attributeToPropertyMap.get(attributeName), (Object)attributeValue);
        } else if (providedProperties.containsKey(propertyKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering optional attribute " + this.attributeToPropertyMap.get(attributeName) + " with property value " + (PASSWORD_ATTRIBUTE.equals(attributeName) ? "******" : providedProperties.get(propertyKey))));
            }
            builder.addPropertyValue(this.attributeToPropertyMap.get(attributeName), providedProperties.get(propertyKey));
        }
        this.removeProvidedProperty(providedProperties, propertyKey);
    }

    private void removeProvidedProperty(Map<String, Object> providedProperties, String attributeName) {
        if (providedProperties.containsKey(attributeName)) {
            providedProperties.remove(attributeName);
        }
    }

    protected void registerBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) {
        super.registerBeanDefinition(beanDefinitionHolder, beanDefinitionRegistry);
    }
}

