/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.springframework.data.r2dbc.repository.query.BindableQuery;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.binding.BindTarget;
import org.springframework.util.Assert;

record PreparedOperationBindableQuery(PreparedOperation<?> preparedQuery) implements BindableQuery
{
    PreparedOperationBindableQuery {
        Assert.notNull(preparedQuery, (String)"Prepared query must not be null");
    }

    @Override
    public DatabaseClient.GenericExecuteSpec bind(DatabaseClient.GenericExecuteSpec bindSpec) {
        BindSpecBindTargetAdapter bindTargetAdapter = new BindSpecBindTargetAdapter(bindSpec);
        this.preparedQuery.bindTo((BindTarget)bindTargetAdapter);
        return bindTargetAdapter.bindSpec;
    }

    @Override
    public String get() {
        return this.preparedQuery.get();
    }

    static class BindSpecBindTargetAdapter
    implements BindTarget {
        DatabaseClient.GenericExecuteSpec bindSpec;

        private BindSpecBindTargetAdapter(DatabaseClient.GenericExecuteSpec bindSpec) {
            this.bindSpec = bindSpec;
        }

        public void bind(String identifier, Object value) {
            this.bindSpec = this.bindSpec.bind(identifier, value);
        }

        public void bind(int index, Object value) {
            this.bindSpec = this.bindSpec.bind(index, value);
        }

        public void bindNull(String identifier, Class<?> type) {
            this.bindSpec = this.bindSpec.bindNull(identifier, type);
        }

        public void bindNull(int index, Class<?> type) {
            this.bindSpec = this.bindSpec.bindNull(index, type);
        }
    }
}

