/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.adapter.RedisListenerExecutionFailedException;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerAdapter
implements MessageListener {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";
    private RedisSerializer<?> serializer;

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void onMessage(Message message, byte[] pattern) {
        try {
            Object convertedMessage;
            String methodName;
            if (this.delegate != this && this.delegate instanceof MessageListener) {
                ((MessageListener)this.delegate).onMessage(message, pattern);
            }
            if ((methodName = this.getListenerMethodName(message, convertedMessage = this.extractMessage(message))) == null) {
                throw new InvalidDataAccessApiUsageException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
            }
            Object[] listenerArguments = this.buildListenerArguments(convertedMessage);
            this.invokeListenerMethod(methodName, listenerArguments);
        }
        catch (Throwable th) {
            this.handleListenerException(th);
        }
    }

    protected void initDefaultStrategies() {
        this.setSerializer(new StringRedisSerializer());
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) {
        if (this.serializer != null) {
            return this.serializer.deserialize(message.getBody());
        }
        return message;
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) {
        return this.getDefaultListenerMethod();
    }

    protected Object[] buildListenerArguments(Object extractedMessage) {
        return new Object[]{extractedMessage};
    }

    protected Object invokeListenerMethod(String methodName, Object[] arguments) {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(arguments);
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof DataAccessException) {
                throw (DataAccessException)targetEx;
            }
            throw new RedisListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            throw new RedisListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with arguments " + ObjectUtils.nullSafeToString((Object[])arguments), ex);
        }
    }
}

