/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import com.google.common.base.Charsets;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.util.Assert;
import redis.client.RedisException;
import redis.reply.BulkReply;
import redis.reply.MultiBulkReply;
import redis.reply.Reply;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SrpUtils {
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] BEFORE = "BEFORE".getBytes(Charsets.UTF_8);
    private static final byte[] AFTER = "AFTER".getBytes(Charsets.UTF_8);
    static final byte[] WITHSCORES = "WITHSCORES".getBytes(Charsets.UTF_8);
    private static final byte[] SPACE = "".getBytes(Charsets.UTF_8);
    private static final byte[] BY = "BY ".getBytes(Charsets.UTF_8);
    private static final byte[] GET = "GET ".getBytes(Charsets.UTF_8);
    private static final byte[] ALPHA = "ALPHA ".getBytes(Charsets.UTF_8);
    private static final byte[] STORE = "STORE ".getBytes(Charsets.UTF_8);

    SrpUtils() {
    }

    static DataAccessException convertSRedisAccessException(RuntimeException ex) {
        if (ex instanceof RedisException) {
            return new RedisSystemException("redis exception", ex);
        }
        return null;
    }

    static Properties info(BulkReply reply) {
        Properties info = new Properties();
        StringReader stringReader = new StringReader(new String(reply.data(), Charsets.UTF_8));
        try {
            info.load(stringReader);
        }
        catch (Exception ex) {
            throw new RedisSystemException("Cannot read Redis info", ex);
        }
        finally {
            stringReader.close();
        }
        return info;
    }

    static List<byte[]> toBytesList(Reply[] replies) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(replies.length);
        for (Reply reply : replies) {
            Object data = reply.data();
            if (data == null) {
                list.add(null);
                continue;
            }
            if (data instanceof byte[]) {
                list.add((byte[])data);
                continue;
            }
            throw new IllegalArgumentException("array contains more then just nulls and bytes -> " + data);
        }
        return list;
    }

    static <T> List<T> toList(T[] byteArrays) {
        return Arrays.asList(byteArrays);
    }

    static Set<byte[]> toSet(Reply[] byteArrays) {
        return new LinkedHashSet<byte[]>(SrpUtils.toBytesList(byteArrays));
    }

    static byte[][] convert(Map<byte[], byte[]> hgetAll) {
        byte[][] result = new byte[hgetAll.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : hgetAll.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    static byte[] asBit(boolean value) {
        return value ? ONE : ZERO;
    }

    static byte[] convertPosition(RedisListCommands.Position where) {
        Assert.notNull((Object)"list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)where) ? AFTER : BEFORE;
    }

    static Double toDouble(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? null : Double.valueOf(new String(bytes, Charsets.UTF_8));
    }

    static Long toLong(Object[] bytes) {
        return bytes == null || bytes.length == 0 ? null : Long.valueOf(new String((byte[])bytes[0], Charsets.UTF_8));
    }

    static Set<RedisZSetCommands.Tuple> convertTuple(MultiBulkReply zrange) {
        Reply[] byteArrays = zrange.data();
        LinkedHashSet<RedisZSetCommands.Tuple> tuples = new LinkedHashSet<RedisZSetCommands.Tuple>(byteArrays.length / 2 + 1);
        for (int i = 0; i < byteArrays.length; ++i) {
            byte[] value = (byte[])byteArrays[i].data();
            Double score = SrpUtils.toDouble((byte[])byteArrays[++i].data());
            tuples.add(new DefaultTuple(value, score));
        }
        return tuples;
    }

    static Map<byte[], byte[]> toMap(Object[] byteArrays) {
        LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>(byteArrays.length / 2);
        for (int i = 0; i < byteArrays.length; ++i) {
            map.put((byte[])byteArrays[i++], (byte[])byteArrays[i]);
        }
        return map;
    }

    static byte[] limit(long offset, long count) {
        return ("LIMIT " + offset + " " + count).getBytes(Charsets.UTF_8);
    }

    static byte[] sort(SortParameters params) {
        return SrpUtils.sort(params, null);
    }

    static byte[] sort(SortParameters params, byte[] sortKey) {
        ArrayList<byte[]> arrays = new ArrayList<byte[]>();
        if (params.getByPattern() != null) {
            arrays.add(BY);
            arrays.add(params.getByPattern());
            arrays.add(SPACE);
        }
        if (params.getLimit() != null) {
            arrays.add(SrpUtils.limit(params.getLimit().getStart(), params.getLimit().getCount()));
            arrays.add(SPACE);
        }
        if (params.getGetPattern() != null) {
            byte[][] pattern;
            for (byte[] bs : pattern = params.getGetPattern()) {
                arrays.add(GET);
                arrays.add(bs);
                arrays.add(SPACE);
            }
        }
        if (params.getOrder() != null) {
            arrays.add(params.getOrder().name().getBytes(Charsets.UTF_8));
            arrays.add(SPACE);
        }
        if (params.isAlphabetic().booleanValue()) {
            arrays.add(ALPHA);
        }
        if (sortKey != null) {
            arrays.add(STORE);
            arrays.add(sortKey);
        }
        int size = 0;
        for (byte[] bs : arrays) {
            size += bs.length;
        }
        byte[] result = new byte[size];
        int index = 0;
        for (byte[] bs : arrays) {
            System.arraycopy(bs, 0, result, index, bs.length);
            index += bs.length;
        }
        return result;
    }
}

