/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.support.collections.AbstractRedisCollection;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.redis.support.collections.RedisIterator;
import org.springframework.data.redis.support.collections.RedisZSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRedisZSet<E>
extends AbstractRedisCollection<E>
implements RedisZSet<E> {
    private final BoundZSetOperations<String, E> boundZSetOps;
    private double defaultScore = 1.0;

    public DefaultRedisZSet(String key, RedisOperations<String, E> operations) {
        this(key, operations, 1.0);
    }

    public DefaultRedisZSet(String key, RedisOperations<String, E> operations, double defaultScore) {
        super(key, operations);
        this.boundZSetOps = operations.boundZSetOps(key);
        this.defaultScore = defaultScore;
    }

    public DefaultRedisZSet(BoundZSetOperations<String, E> boundOps) {
        this(boundOps, 1.0);
    }

    public DefaultRedisZSet(BoundZSetOperations<String, E> boundOps, double defaultScore) {
        super((String)boundOps.getKey(), boundOps.getOperations());
        this.boundZSetOps = boundOps;
        this.defaultScore = defaultScore;
    }

    @Override
    public RedisZSet<E> intersectAndStore(RedisZSet<?> set, String destKey) {
        this.boundZSetOps.intersectAndStore((String)set.getKey(), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public RedisZSet<E> intersectAndStore(Collection<? extends RedisZSet<?>> sets, String destKey) {
        this.boundZSetOps.intersectAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public Set<E> range(long start, long end) {
        return this.boundZSetOps.range(start, end);
    }

    @Override
    public Set<E> reverseRange(long start, long end) {
        return this.boundZSetOps.reverseRange(start, end);
    }

    @Override
    public Set<E> rangeByScore(double min, double max) {
        return this.boundZSetOps.rangeByScore(min, max);
    }

    @Override
    public Set<E> reverseRangeByScore(double min, double max) {
        return this.boundZSetOps.reverseRangeByScore(min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> rangeByScoreWithScores(double min, double max) {
        return this.boundZSetOps.rangeByScoreWithScores(min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> rangeWithScores(long start, long end) {
        return this.boundZSetOps.rangeWithScores(start, end);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> reverseRangeByScoreWithScores(double min, double max) {
        return this.boundZSetOps.reverseRangeByScoreWithScores(min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<E>> reverseRangeWithScores(long start, long end) {
        return this.boundZSetOps.reverseRangeWithScores(start, end);
    }

    @Override
    public RedisZSet<E> remove(long start, long end) {
        this.boundZSetOps.removeRange(start, end);
        return this;
    }

    @Override
    public RedisZSet<E> removeByScore(double min, double max) {
        this.boundZSetOps.removeRangeByScore(min, max);
        return this;
    }

    @Override
    public RedisZSet<E> unionAndStore(RedisZSet<?> set, String destKey) {
        this.boundZSetOps.unionAndStore((String)set.getKey(), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public RedisZSet<E> unionAndStore(Collection<? extends RedisZSet<?>> sets, String destKey) {
        this.boundZSetOps.unionAndStore(CollectionUtils.extractKeys(sets), destKey);
        return new DefaultRedisZSet<E>(this.boundZSetOps.getOperations().boundZSetOps(destKey), this.getDefaultScore());
    }

    @Override
    public boolean add(E e) {
        Boolean result = this.add(e, this.getDefaultScore());
        this.checkResult(result);
        return result;
    }

    @Override
    public boolean add(E e, double score) {
        Boolean result = this.boundZSetOps.add(e, score);
        this.checkResult(result);
        return result;
    }

    @Override
    public void clear() {
        this.boundZSetOps.removeRange(0L, -1L);
    }

    @Override
    public boolean contains(Object o) {
        return this.boundZSetOps.rank(o) != null;
    }

    @Override
    public Iterator<E> iterator() {
        Set<E> members = this.boundZSetOps.range(0L, -1L);
        this.checkResult(members);
        return new DefaultRedisSortedSetIterator(members.iterator());
    }

    @Override
    public boolean remove(Object o) {
        Long result = this.boundZSetOps.remove(o);
        this.checkResult(result);
        return result == 1L;
    }

    @Override
    public int size() {
        Long result = this.boundZSetOps.size();
        this.checkResult(result);
        return result.intValue();
    }

    @Override
    public Double getDefaultScore() {
        return this.defaultScore;
    }

    @Override
    public E first() {
        Set<E> members = this.boundZSetOps.range(0L, 0L);
        this.checkResult(members);
        Iterator<E> iterator = members.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() {
        Set<E> members = this.boundZSetOps.reverseRange(0L, 0L);
        this.checkResult(members);
        Iterator<E> iterator = members.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long rank(Object o) {
        return this.boundZSetOps.rank(o);
    }

    @Override
    public Long reverseRank(Object o) {
        return this.boundZSetOps.reverseRank(o);
    }

    @Override
    public Double score(Object o) {
        return this.boundZSetOps.score(o);
    }

    @Override
    public DataType getType() {
        return DataType.ZSET;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultRedisSortedSetIterator
    extends RedisIterator<E> {
        public DefaultRedisSortedSetIterator(Iterator<E> delegate) {
            super(delegate);
        }

        @Override
        protected void removeFromRedisStorage(E item) {
            DefaultRedisZSet.this.remove(item);
        }
    }
}

