/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.protocol.Charsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.util.Assert;

public abstract class LettuceConverters
extends Converters {
    private static final Converter<Date, Long> DATE_TO_LONG;
    private static final Converter<List<byte[]>, Set<byte[]>> BYTES_LIST_TO_BYTES_SET;
    private static final Converter<Set<byte[]>, List<byte[]>> BYTES_SET_TO_BYTES_LIST;
    private static final Converter<KeyValue<byte[], byte[]>, List<byte[]>> KEY_VALUE_TO_BYTES_LIST;
    private static final Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>> SCORED_VALUES_TO_TUPLE_SET;
    private static final Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple> SCORED_VALUE_TO_TUPLE;
    private static final Converter<Exception, DataAccessException> EXCEPTION_CONVERTER;

    public static Converter<Date, Long> dateToLong() {
        return DATE_TO_LONG;
    }

    public static Converter<List<byte[]>, Set<byte[]>> bytesListToBytesSet() {
        return BYTES_LIST_TO_BYTES_SET;
    }

    public static Converter<KeyValue<byte[], byte[]>, List<byte[]>> keyValueToBytesList() {
        return KEY_VALUE_TO_BYTES_LIST;
    }

    public static Converter<Set<byte[]>, List<byte[]>> bytesSetToBytesList() {
        return BYTES_SET_TO_BYTES_LIST;
    }

    public static Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>> scoredValuesToTupleSet() {
        return SCORED_VALUES_TO_TUPLE_SET;
    }

    public static Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple> scoredValueToTuple() {
        return SCORED_VALUE_TO_TUPLE;
    }

    public static Converter<Exception, DataAccessException> exceptionConverter() {
        return EXCEPTION_CONVERTER;
    }

    public static Long toLong(Date source) {
        return (Long)DATE_TO_LONG.convert((Object)source);
    }

    public static Set<byte[]> toBytesSet(List<byte[]> source) {
        return (Set)BYTES_LIST_TO_BYTES_SET.convert(source);
    }

    public static List<byte[]> toBytesList(KeyValue<byte[], byte[]> source) {
        return (List)KEY_VALUE_TO_BYTES_LIST.convert(source);
    }

    public static List<byte[]> toBytesList(Set<byte[]> source) {
        return (List)BYTES_SET_TO_BYTES_LIST.convert(source);
    }

    public static Set<RedisZSetCommands.Tuple> toTupleSet(List<ScoredValue<byte[]>> source) {
        return (Set)SCORED_VALUES_TO_TUPLE_SET.convert(source);
    }

    public static RedisZSetCommands.Tuple toTuple(ScoredValue<byte[]> source) {
        return (RedisZSetCommands.Tuple)SCORED_VALUE_TO_TUPLE.convert(source);
    }

    public static DataAccessException toDataAccessException(Exception ex) {
        return (DataAccessException)((Object)EXCEPTION_CONVERTER.convert((Object)ex));
    }

    public static ScriptOutputType toScriptOutputType(ReturnType returnType) {
        switch (returnType) {
            case BOOLEAN: {
                return ScriptOutputType.BOOLEAN;
            }
            case MULTI: {
                return ScriptOutputType.MULTI;
            }
            case VALUE: {
                return ScriptOutputType.VALUE;
            }
            case INTEGER: {
                return ScriptOutputType.INTEGER;
            }
            case STATUS: {
                return ScriptOutputType.STATUS;
            }
        }
        throw new IllegalArgumentException("Return type " + (Object)((Object)returnType) + " is not a supported script output type");
    }

    public static boolean toBoolean(RedisListCommands.Position where) {
        Assert.notNull((Object)"list positions are mandatory");
        return !RedisListCommands.Position.AFTER.equals((Object)where);
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static SortArgs toSortArgs(SortParameters params) {
        Boolean isAlpha;
        SortArgs args = new SortArgs();
        if (params == null) {
            return args;
        }
        if (params.getByPattern() != null) {
            args.by(new String(params.getByPattern(), Charsets.ASCII));
        }
        if (params.getLimit() != null) {
            args.limit(params.getLimit().getStart(), params.getLimit().getCount());
        }
        if (params.getGetPattern() != null) {
            byte[][] pattern;
            for (byte[] bs : pattern = params.getGetPattern()) {
                args.get(new String(bs, Charsets.ASCII));
            }
        }
        if (params.getOrder() != null) {
            if (params.getOrder() == SortParameters.Order.ASC) {
                args.asc();
            } else {
                args.desc();
            }
        }
        if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
            args.alpha();
        }
        return args;
    }

    static {
        EXCEPTION_CONVERTER = new LettuceExceptionConverter();
        DATE_TO_LONG = new Converter<Date, Long>(){

            public Long convert(Date source) {
                return source != null ? Long.valueOf(source.getTime()) : null;
            }
        };
        BYTES_LIST_TO_BYTES_SET = new Converter<List<byte[]>, Set<byte[]>>(){

            public Set<byte[]> convert(List<byte[]> results) {
                return results != null ? new LinkedHashSet<byte[]>(results) : null;
            }
        };
        BYTES_SET_TO_BYTES_LIST = new Converter<Set<byte[]>, List<byte[]>>(){

            public List<byte[]> convert(Set<byte[]> results) {
                return results != null ? new ArrayList<byte[]>(results) : null;
            }
        };
        KEY_VALUE_TO_BYTES_LIST = new Converter<KeyValue<byte[], byte[]>, List<byte[]>>(){

            public List<byte[]> convert(KeyValue<byte[], byte[]> source) {
                if (source == null) {
                    return null;
                }
                ArrayList<byte[]> list = new ArrayList<byte[]>(2);
                list.add((byte[])source.key);
                list.add((byte[])source.value);
                return list;
            }
        };
        SCORED_VALUES_TO_TUPLE_SET = new Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>>(){

            public Set<RedisZSetCommands.Tuple> convert(List<ScoredValue<byte[]>> source) {
                if (source == null) {
                    return null;
                }
                LinkedHashSet<RedisZSetCommands.Tuple> tuples = new LinkedHashSet<RedisZSetCommands.Tuple>(source.size());
                for (ScoredValue<byte[]> value : source) {
                    tuples.add(LettuceConverters.toTuple(value));
                }
                return tuples;
            }
        };
        SCORED_VALUE_TO_TUPLE = new Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple>(){

            public RedisZSetCommands.Tuple convert(ScoredValue<byte[]> source) {
                return source != null ? new DefaultTuple((byte[])source.value, source.score) : null;
            }
        };
    }
}

