/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveKeyCommands {
    default public Mono<Boolean> exists(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exists((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.KeyCommand>> exists(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<DataType> type(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.type((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, DataType>> type(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<List<ByteBuffer>> keys(ByteBuffer pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        return this.keys((Publisher<ByteBuffer>)Mono.just((Object)pattern)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Mono<ByteBuffer> randomKey();

    public Flux<ReactiveRedisConnection.MultiValueResponse<ByteBuffer, ByteBuffer>> keys(Publisher<ByteBuffer> var1);

    default public Mono<Boolean> rename(ByteBuffer key, ByteBuffer newName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.rename((Publisher<RenameCommand>)Mono.just((Object)RenameCommand.key(key).to(newName))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<RenameCommand>> rename(Publisher<RenameCommand> var1);

    default public Mono<Boolean> renameNX(ByteBuffer key, ByteBuffer newName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.renameNX((Publisher<RenameCommand>)Mono.just((Object)RenameCommand.key(key).to(newName))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<RenameCommand>> renameNX(Publisher<RenameCommand> var1);

    default public Mono<Long> del(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.del((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> del(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Long> mDel(List<ByteBuffer> keys) {
        Assert.notEmpty(keys, (String)"Keys must not be empty or null!");
        return this.mDel((Publisher<List<ByteBuffer>>)Mono.just(keys)).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<List<ByteBuffer>, Long>> mDel(Publisher<List<ByteBuffer>> var1);

    public static class RenameCommand
    extends ReactiveRedisConnection.KeyCommand {
        private ByteBuffer newName;

        private RenameCommand(ByteBuffer key, ByteBuffer newName) {
            super(key);
            this.newName = newName;
        }

        public static RenameCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new RenameCommand(key, null);
        }

        public RenameCommand to(ByteBuffer newName) {
            Assert.notNull((Object)newName, (String)"New name must not be null!");
            return new RenameCommand(this.getKey(), newName);
        }

        public ByteBuffer getNewName() {
            return this.newName;
        }
    }
}

