/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.api.reactive.RedisKeyReactiveCommands;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisClusterConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LettuceReactiveClusterKeyCommands
extends LettuceReactiveKeyCommands
implements ReactiveClusterKeyCommands {
    private LettuceReactiveRedisClusterConnection connection;

    public LettuceReactiveClusterKeyCommands(LettuceReactiveRedisClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public Mono<List<ByteBuffer>> keys(RedisClusterNode node, ByteBuffer pattern) {
        return this.connection.execute(node, cmd -> {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
            return cmd.keys((Object)pattern).collectList();
        }).next();
    }

    @Override
    public Mono<ByteBuffer> randomKey(RedisClusterNode node) {
        return this.connection.execute(node, RedisKeyReactiveCommands::randomkey).next();
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"key must not be null.");
            Assert.notNull((Object)command.getNewName(), (String)"NewName must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getNewName())) {
                return super.rename((Publisher<ReactiveKeyCommands.RenameCommand>)Mono.just((Object)command));
            }
            Flux result = cmd.dump((Object)command.getKey()).otherwiseIfEmpty(Mono.error((Throwable)((Object)new RedisSystemException("Cannot rename key that does not exist", new RedisException("ERR no such key."))))).flatMap(value -> cmd.restore((Object)command.getNewName(), 0L, value).flatMap(res -> cmd.del((Object[])new ByteBuffer[]{command.getKey()}))).map(arg_0 -> LettuceConverters.longToBooleanConverter().convert(arg_0));
            return result.map(val -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)val));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null.");
            Assert.notNull((Object)command.getNewName(), (String)"NewName must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getNewName())) {
                return super.renameNX((Publisher<ReactiveKeyCommands.RenameCommand>)Mono.just((Object)command));
            }
            Flux result = cmd.exists((Object[])new ByteBuffer[]{command.getNewName()}).flatMap(exists -> {
                if (exists == 1L) {
                    return Mono.just((Object)Boolean.FALSE);
                }
                return cmd.dump((Object)command.getKey()).otherwiseIfEmpty(Mono.error((Throwable)((Object)new RedisSystemException("Cannot rename key that does not exist", new RedisException("ERR no such key."))))).flatMap(value -> cmd.restore((Object)command.getNewName(), 0L, value).flatMap(res -> cmd.del((Object[])new ByteBuffer[]{command.getKey()}))).map(arg_0 -> LettuceConverters.longToBooleanConverter().convert(arg_0));
            });
            return result.map(val -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)val));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>> move(Publisher<ReactiveKeyCommands.MoveCommand> commands) {
        throw new UnsupportedOperationException("MOVE not supported in CLUSTER mode!");
    }
}

