/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.reactive.RedisClusterReactiveCommands;
import com.lambdaworks.redis.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveNumberCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveNumberCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveZSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class LettuceReactiveRedisConnection
implements ReactiveRedisConnection {
    private StatefulConnection<ByteBuffer, ByteBuffer> connection;
    private static final RedisCodec<ByteBuffer, ByteBuffer> CODEC = ByteBufferCodec.INSTANCE;

    public LettuceReactiveRedisConnection(AbstractRedisClient client) {
        Assert.notNull((Object)client, (String)"RedisClient must not be null!");
        if (client instanceof RedisClient) {
            this.connection = ((RedisClient)client).connect(CODEC);
        } else if (client instanceof RedisClusterClient) {
            this.connection = ((RedisClusterClient)client).connect(CODEC);
        } else {
            throw new InvalidDataAccessResourceUsageException(String.format("Cannot use client of type %s", client.getClass()));
        }
    }

    @Override
    public ReactiveKeyCommands keyCommands() {
        return new LettuceReactiveKeyCommands(this);
    }

    @Override
    public ReactiveStringCommands stringCommands() {
        return new LettuceReactiveStringCommands(this);
    }

    @Override
    public ReactiveNumberCommands numberCommands() {
        return new LettuceReactiveNumberCommands(this);
    }

    @Override
    public ReactiveListCommands listCommands() {
        return new LettuceReactiveListCommands(this);
    }

    @Override
    public ReactiveSetCommands setCommands() {
        return new LettuceReactiveSetCommands(this);
    }

    @Override
    public ReactiveZSetCommands zSetCommands() {
        return new LettuceReactiveZSetCommands(this);
    }

    @Override
    public ReactiveHashCommands hashCommands() {
        return new LettuceReactiveHashCommands(this);
    }

    @Override
    public ReactiveGeoCommands geoCommands() {
        return new LettuceReactiveGeoCommands(this);
    }

    @Override
    public ReactiveHyperLogLogCommands hyperLogLogCommands() {
        return new LettuceReactiveHyperLogLogCommands(this);
    }

    public <T> Flux<T> execute(LettuceReactiveCallback<T> callback) {
        return Flux.defer(() -> callback.doWithCommands(this.getCommands())).onErrorResumeWith(this.translateExeception());
    }

    @Override
    public void close() {
        this.connection.close();
    }

    protected StatefulConnection<ByteBuffer, ByteBuffer> getConnection() {
        return this.connection;
    }

    protected RedisClusterReactiveCommands<ByteBuffer, ByteBuffer> getCommands() {
        if (this.connection instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)this.connection).reactive();
        }
        if (this.connection instanceof StatefulRedisClusterConnection) {
            return ((StatefulRedisClusterConnection)this.connection).reactive();
        }
        throw new RuntimeException("o.O unknown connection type " + this.connection);
    }

    <T> Function<Throwable, Publisher<? extends T>> translateExeception() {
        return throwable -> {
            if (throwable instanceof RuntimeException) {
                Throwable convertedException = null;
                if (throwable instanceof RuntimeException) {
                    convertedException = (DataAccessException)((Object)((Object)LettuceConverters.exceptionConverter().convert((Object)((RuntimeException)throwable))));
                }
                return Flux.error((Throwable)(convertedException != null ? convertedException : throwable));
            }
            return Flux.error((Throwable)throwable);
        };
    }

    static enum ByteBufferCodec implements RedisCodec<ByteBuffer, ByteBuffer>
    {
        INSTANCE;


        public ByteBuffer decodeKey(ByteBuffer bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.remaining());
            buffer.put(bytes);
            buffer.flip();
            return buffer;
        }

        public ByteBuffer decodeValue(ByteBuffer bytes) {
            return this.decodeKey(bytes);
        }

        public ByteBuffer encodeKey(ByteBuffer key) {
            return key.duplicate();
        }

        public ByteBuffer encodeValue(ByteBuffer value) {
            return value.duplicate();
        }
    }

    static interface LettuceReactiveCallback<T> {
        public Publisher<T> doWithCommands(RedisClusterReactiveCommands<ByteBuffer, ByteBuffer> var1);
    }
}

