/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.SimpleIndexedPropertyValue;
import org.springframework.data.redis.core.index.ConfigurableIndexDefinitionProvider;
import org.springframework.data.redis.core.index.IndexDefinition;
import org.springframework.data.redis.core.index.SpelIndexDefinition;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpelIndexResolver
implements IndexResolver {
    private final ConfigurableIndexDefinitionProvider settings;
    private final SpelExpressionParser parser;
    private final RedisMappingContext mappingContext;
    private final Map<SpelIndexDefinition, Expression> expressionCache;
    @Nullable
    private BeanResolver beanResolver;

    public SpelIndexResolver(RedisMappingContext mappingContext) {
        this(mappingContext, new SpelExpressionParser());
    }

    public SpelIndexResolver(RedisMappingContext mappingContext, SpelExpressionParser parser) {
        Assert.notNull((Object)((Object)mappingContext), (String)"RedisMappingContext must not be null");
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null");
        this.mappingContext = mappingContext;
        this.settings = mappingContext.getMappingConfiguration().getIndexConfiguration();
        this.expressionCache = new HashMap<SpelIndexDefinition, Expression>();
        this.parser = parser;
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(TypeInformation<?> typeInformation, @Nullable Object value) {
        if (value == null) {
            return Collections.emptySet();
        }
        RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(typeInformation);
        if (entity == null) {
            return Collections.emptySet();
        }
        String keyspace = entity.getKeySpace();
        HashSet<IndexedData> indexes = new HashSet<IndexedData>();
        for (IndexDefinition setting : this.settings.getIndexDefinitionsFor((Serializable)((Object)keyspace))) {
            Object index;
            if (!(setting instanceof SpelIndexDefinition)) continue;
            SpelIndexDefinition spel = (SpelIndexDefinition)setting;
            Expression expression = this.getAndCacheIfAbsent(spel);
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(value);
            context.setVariable("this", value);
            if (this.beanResolver != null) {
                context.setBeanResolver(this.beanResolver);
            }
            if ((index = expression.getValue((EvaluationContext)context)) == null) continue;
            indexes.add(new SimpleIndexedPropertyValue(keyspace, setting.getIndexName(), index));
        }
        return indexes;
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(String keyspace, String path, TypeInformation<?> typeInformation, Object value) {
        return Collections.emptySet();
    }

    private Expression getAndCacheIfAbsent(SpelIndexDefinition indexDefinition) {
        if (this.expressionCache.containsKey(indexDefinition)) {
            return this.expressionCache.get(indexDefinition);
        }
        Expression expression = this.parser.parseExpression(indexDefinition.getExpression());
        this.expressionCache.put(indexDefinition, expression);
        return expression;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }
}

