/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.Assert;

@NullUnmarked
public interface BoundZSetOperations<K, V>
extends BoundKeyOperations<K> {
    public Boolean add(@NonNull V var1, double var2);

    public Boolean addIfAbsent(@NonNull V var1, double var2);

    public Long add(Set<@NonNull ZSetOperations.TypedTuple<V>> var1);

    public Long addIfAbsent(Set<@NonNull ZSetOperations.TypedTuple<V>> var1);

    public Long remove(Object ... var1);

    public Double incrementScore(@NonNull V var1, double var2);

    public V randomMember();

    public Set<V> distinctRandomMembers(long var1);

    public List<V> randomMembers(long var1);

    public ZSetOperations.TypedTuple<V> randomMemberWithScore();

    public Set<@NonNull ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(long var1);

    public List<@NonNull ZSetOperations.TypedTuple<V>> randomMembersWithScore(long var1);

    public Long rank(@NonNull Object var1);

    public Long reverseRank(@NonNull Object var1);

    public Set<V> range(long var1, long var3);

    public Set<@NonNull ZSetOperations.TypedTuple<V>> rangeWithScores(long var1, long var3);

    public Set<V> rangeByScore(double var1, double var3);

    public Set<@NonNull ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(double var1, double var3);

    public Set<V> reverseRange(long var1, long var3);

    public Set<@NonNull ZSetOperations.TypedTuple<V>> reverseRangeWithScores(long var1, long var3);

    public Set<V> reverseRangeByScore(double var1, double var3);

    public Set<@NonNull ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(double var1, double var3);

    public Long count(double var1, double var3);

    public Long lexCount(@NonNull Range<String> var1);

    public ZSetOperations.TypedTuple<V> popMin();

    public Set<@NonNull ZSetOperations.TypedTuple<V>> popMin(long var1);

    public ZSetOperations.TypedTuple<V> popMin(long var1, @NonNull TimeUnit var3);

    default public ZSetOperations.TypedTuple<V> popMin(@NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMin(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public ZSetOperations.TypedTuple<V> popMax();

    public Set<@NonNull ZSetOperations.TypedTuple<V>> popMax(long var1);

    public ZSetOperations.TypedTuple<V> popMax(long var1, @NonNull TimeUnit var3);

    default public ZSetOperations.TypedTuple<V> popMax(@NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMax(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public Long size();

    public Long zCard();

    public Double score(@NonNull Object var1);

    public List<Double> score(Object ... var1);

    public Long removeRange(long var1, long var3);

    public Long removeRangeByLex(@NonNull Range<String> var1);

    public Long removeRangeByScore(double var1, double var3);

    public Long unionAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2, @NonNull Aggregate var3, @NonNull Weights var4);

    default public Set<V> difference(@NonNull K otherKey) {
        return this.difference((Collection<K>)Collections.singleton(otherKey));
    }

    public Set<V> difference(@NonNull Collection<@NonNull K> var1);

    default public Set<@NonNull ZSetOperations.TypedTuple<V>> differenceWithScores(@NonNull K otherKey) {
        return this.differenceWithScores((Collection<K>)Collections.singleton(otherKey));
    }

    public Set<@NonNull ZSetOperations.TypedTuple<V>> differenceWithScores(@NonNull Collection<@NonNull K> var1);

    default public Long differenceAndStore(@NonNull K otherKey, @NonNull K destKey) {
        return this.differenceAndStore((Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public Long differenceAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2);

    default public Set<V> intersect(@NonNull K otherKey) {
        return this.intersect((Collection<K>)Collections.singleton(otherKey));
    }

    public Set<V> intersect(@NonNull Collection<@NonNull K> var1);

    default public Set<@NonNull ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K otherKey) {
        return this.intersectWithScores((Collection<K>)Collections.singleton(otherKey));
    }

    public Set<@NonNull ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull Collection<@NonNull K> var1);

    public Set<@NonNull ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull Collection<@NonNull K> var1, @NonNull Aggregate var2, @NonNull Weights var3);

    public Long intersectAndStore(@NonNull K var1, @NonNull K var2);

    public Long intersectAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2);

    public Long intersectAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2, @NonNull Aggregate var3);

    public Long intersectAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2, @NonNull Aggregate var3, @NonNull Weights var4);

    default public Set<V> union(@NonNull K otherKey) {
        return this.union((Collection<K>)Collections.singleton(otherKey));
    }

    public Set<V> union(@NonNull Collection<@NonNull K> var1);

    default public Set<@NonNull ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K otherKey) {
        return this.unionWithScores((Collection<K>)Collections.singleton(otherKey));
    }

    public Set<@NonNull ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull Collection<@NonNull K> var1);

    default public Set<@NonNull ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull Collection<@NonNull K> otherKeys, @NonNull Aggregate aggregate) {
        return this.unionWithScores(otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Set<@NonNull ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull Collection<@NonNull K> var1, @NonNull Aggregate var2, @NonNull Weights var3);

    public Long unionAndStore(@NonNull K var1, @NonNull K var2);

    public Long unionAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2);

    public Long unionAndStore(@NonNull Collection<@NonNull K> var1, @NonNull K var2, @NonNull Aggregate var3);

    public Cursor<@NonNull ZSetOperations.TypedTuple<V>> scan(@NonNull ScanOptions var1);

    default public Set<V> rangeByLex(@NonNull Range<String> range) {
        return this.rangeByLex(range, Limit.unlimited());
    }

    public Set<V> rangeByLex(Range<String> var1, @NonNull Limit var2);

    default public Set<V> reverseRangeByLex(@NonNull Range<String> range) {
        return this.reverseRangeByLex(range, Limit.unlimited());
    }

    public Set<V> reverseRangeByLex(@NonNull Range<String> var1, @NonNull Limit var2);

    default public Long rangeAndStoreByLex(@NonNull K dstKey, @NonNull Range<String> range) {
        return this.rangeAndStoreByLex(dstKey, range, Limit.unlimited());
    }

    public Long rangeAndStoreByLex(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public Long reverseRangeAndStoreByLex(@NonNull K dstKey, @NonNull Range<String> range) {
        return this.reverseRangeAndStoreByLex(dstKey, range, Limit.unlimited());
    }

    public Long reverseRangeAndStoreByLex(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public Long rangeAndStoreByScore(@NonNull K dstKey, @NonNull Range<? extends Number> range) {
        return this.rangeAndStoreByScore(dstKey, range, Limit.unlimited());
    }

    public Long rangeAndStoreByScore(@NonNull K var1, @NonNull Range<? extends Number> var2, @NonNull Limit var3);

    default public Long reverseRangeAndStoreByScore(@NonNull K dstKey, @NonNull Range<? extends Number> range) {
        return this.reverseRangeAndStoreByScore(dstKey, range, Limit.unlimited());
    }

    public Long reverseRangeAndStoreByScore(@NonNull K var1, @NonNull Range<? extends Number> var2, @NonNull Limit var3);

    @Override
    public @NonNull RedisOperations<K, V> getOperations();
}

