/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class PartialUpdate<T> {
    private final Object id;
    private final Class<T> target;
    private final @Nullable T value;
    private boolean refreshTtl = false;
    private final List<PropertyUpdate> propertyUpdates = new ArrayList<PropertyUpdate>();

    private PartialUpdate(Object id, Class<T> target, @Nullable T value, boolean refreshTtl, List<PropertyUpdate> propertyUpdates) {
        this.id = id;
        this.target = target;
        this.value = value;
        this.refreshTtl = refreshTtl;
        this.propertyUpdates.addAll(propertyUpdates);
    }

    public PartialUpdate(Object id, Class<T> targetType) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(targetType, (String)"TargetType must not be null");
        this.id = id;
        this.target = ClassUtils.getUserClass(targetType);
        this.value = null;
    }

    public PartialUpdate(Object id, T value) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(value, (String)"Value must not be null");
        this.id = id;
        this.target = ClassUtils.getUserClass(value.getClass());
        this.value = value;
    }

    public static <S> PartialUpdate<S> newPartialUpdate(Object id, Class<S> targetType) {
        return new PartialUpdate<Class<S>>(id, targetType);
    }

    public @Nullable T getValue() {
        return this.value;
    }

    public PartialUpdate<T> set(String path, Object value) {
        Assert.hasText((String)path, (String)"Path to set must not be null or empty");
        PartialUpdate<T> update = new PartialUpdate<T>(this.id, this.target, this.value, this.refreshTtl, this.propertyUpdates);
        update.propertyUpdates.add(new PropertyUpdate(UpdateCommand.SET, path, value));
        return update;
    }

    public PartialUpdate<T> del(String path) {
        Assert.hasText((String)path, (String)"Path to remove must not be null or empty");
        PartialUpdate<T> update = new PartialUpdate<T>(this.id, this.target, this.value, this.refreshTtl, this.propertyUpdates);
        update.propertyUpdates.add(new PropertyUpdate(UpdateCommand.DEL, path));
        return update;
    }

    public Class<T> getTarget() {
        return this.target;
    }

    public Object getId() {
        return this.id;
    }

    public List<PropertyUpdate> getPropertyUpdates() {
        return Collections.unmodifiableList(this.propertyUpdates);
    }

    public boolean isRefreshTtl() {
        return this.refreshTtl;
    }

    public PartialUpdate<T> refreshTtl(boolean refreshTtl) {
        return new PartialUpdate<T>(this.id, this.target, this.value, refreshTtl, this.propertyUpdates);
    }

    public static class PropertyUpdate {
        private final UpdateCommand cmd;
        private final String propertyPath;
        private final @Nullable Object value;

        private PropertyUpdate(UpdateCommand cmd, String propertyPath) {
            this(cmd, propertyPath, null);
        }

        private PropertyUpdate(UpdateCommand cmd, String propertyPath, @Nullable Object value) {
            this.cmd = cmd;
            this.propertyPath = propertyPath;
            this.value = value;
        }

        public UpdateCommand getCmd() {
            return this.cmd;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        public @Nullable Object getValue() {
            return this.value;
        }
    }

    public static enum UpdateCommand {
        SET,
        DEL;

    }
}

