/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.BindMarker;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Literal;
import org.springframework.data.relational.core.sql.Named;
import org.springframework.data.relational.core.sql.SubselectExpression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.data.relational.core.sql.render.SelectStatementVisitor;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;

class ExpressionVisitor
extends TypedSubtreeVisitor<Expression>
implements PartRenderer {
    private final RenderContext context;
    private CharSequence value = "";
    @Nullable
    private PartRenderer partRenderer;

    ExpressionVisitor(RenderContext context) {
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Expression segment) {
        if (segment instanceof SubselectExpression) {
            SelectStatementVisitor visitor = new SelectStatementVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof Column) {
            RenderNamingStrategy namingStrategy = this.context.getNamingStrategy();
            Column column = (Column)segment;
            this.value = namingStrategy.getReferenceName(column.getTable()) + "." + namingStrategy.getReferenceName(column);
        } else if (segment instanceof BindMarker) {
            this.value = segment instanceof Named ? ((Named)((Object)segment)).getName() : segment.toString();
        } else if (segment instanceof Literal) {
            this.value = segment.toString();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Condition) {
            ConditionVisitor visitor = new ConditionVisitor(this.context);
            this.partRenderer = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Expression segment) {
        if (this.partRenderer != null) {
            this.value = this.partRenderer.getRenderedPart();
            this.partRenderer = null;
        }
        return super.leaveMatched(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.value;
    }
}

