/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.BasicRelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.CachingNamingStrategy;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntityImpl;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class RelationalMappingContext
extends AbstractMappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> {
    private final NamingStrategy namingStrategy;

    public RelationalMappingContext() {
        this(NamingStrategy.INSTANCE);
    }

    public RelationalMappingContext(NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null!");
        this.namingStrategy = new CachingNamingStrategy(namingStrategy);
        this.setSimpleTypeHolder(SimpleTypeHolder.DEFAULT);
    }

    protected <T> RelationalPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new RelationalPersistentEntityImpl<T>(typeInformation, this.namingStrategy);
    }

    protected RelationalPersistentProperty createPersistentProperty(Property property, RelationalPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new BasicRelationalPersistentProperty(property, (PersistentEntity<?, RelationalPersistentProperty>)owner, simpleTypeHolder, this);
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }
}

