/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.Stack;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class DelegatingVisitor
implements Visitor {
    private Stack<DelegatingVisitor> delegation = new Stack();

    DelegatingVisitor() {
    }

    @Nullable
    public abstract Delegation doEnter(Visitable var1);

    @Override
    public final void enter(Visitable segment) {
        if (this.delegation.isEmpty()) {
            Delegation visitor = this.doEnter(segment);
            Assert.notNull((Object)visitor, () -> String.format("Visitor must not be null. Caused by %s.doEnter(\u2026)", this.getClass().getName()));
            Assert.state((!visitor.isLeave() ? 1 : 0) != 0, () -> String.format("Delegation indicates leave. Caused by %s.doEnter(\u2026)", this.getClass().getName()));
            if (visitor.isDelegate()) {
                this.delegation.push(visitor.getDelegate());
                visitor.getDelegate().enter(segment);
            }
        } else {
            this.delegation.peek().enter(segment);
        }
    }

    public abstract Delegation doLeave(Visitable var1);

    @Override
    public final void leave(Visitable segment) {
        this.doLeave0(segment);
    }

    private Delegation doLeave0(Visitable segment) {
        if (this.delegation.isEmpty()) {
            return this.doLeave(segment);
        }
        DelegatingVisitor visitor = this.delegation.peek();
        while (visitor != null) {
            Delegation result = visitor.doLeave0(segment);
            Assert.notNull((Object)visitor, () -> String.format("Visitor must not be null. Caused by %s.doLeave(\u2026)", this.getClass().getName()));
            if (visitor == this) {
                if (result.isLeave()) {
                    return this.delegation.isEmpty() ? Delegation.leave() : Delegation.retain();
                }
                return Delegation.retain();
            }
            if (result.isRetain()) {
                return result;
            }
            if (!result.isLeave()) continue;
            if (!this.delegation.isEmpty()) {
                this.delegation.pop();
            }
            if (!this.delegation.isEmpty()) {
                visitor = this.delegation.peek();
                continue;
            }
            visitor = this;
        }
        return Delegation.leave();
    }

    static class Delegation {
        private static Delegation RETAIN = new Delegation(true, false, null);
        private static Delegation LEAVE = new Delegation(false, true, null);
        private final boolean retain;
        private final boolean leave;
        @Nullable
        private final DelegatingVisitor delegate;

        private Delegation(boolean retain, boolean leave, @Nullable DelegatingVisitor delegate) {
            this.retain = retain;
            this.leave = leave;
            this.delegate = delegate;
        }

        public static Delegation retain() {
            return RETAIN;
        }

        public static Delegation leave() {
            return LEAVE;
        }

        public static Delegation delegateTo(DelegatingVisitor visitor) {
            return new Delegation(false, false, visitor);
        }

        boolean isDelegate() {
            return this.delegate != null;
        }

        boolean isRetain() {
            return this.retain;
        }

        boolean isLeave() {
            return this.leave;
        }

        DelegatingVisitor getDelegate() {
            Assert.state((boolean)this.isDelegate(), (String)"No delegate available");
            return this.delegate;
        }
    }
}

