/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.AggregatePathTraversal;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;

class DefaultAggregatePath
implements AggregatePath {
    private final RelationalMappingContext context;
    private final @Nullable RelationalPersistentEntity<?> rootType;
    private final @Nullable PersistentPropertyPath<RelationalPersistentProperty> path;
    private final Lazy<AggregatePath.TableInfo> tableInfo = Lazy.of(() -> AggregatePath.TableInfo.of(this));
    private final Lazy<AggregatePath.ColumnInfo> columnInfo = Lazy.of(() -> AggregatePath.ColumnInfo.of(this));
    private final ConcurrentLruCache<RelationalPersistentProperty, AggregatePath> nestedCache;

    DefaultAggregatePath(RelationalMappingContext context, PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        Assert.notNull((Object)((Object)context), (String)"context must not be null");
        Assert.notNull(path, (String)"path must not be null");
        this.context = context;
        this.path = path;
        this.rootType = ((RelationalPersistentProperty)path.getBaseProperty()).getOwner();
        this.nestedCache = new ConcurrentLruCache(32, this::doGetAggegatePath);
    }

    DefaultAggregatePath(RelationalMappingContext context, RelationalPersistentEntity<?> rootType) {
        Assert.notNull((Object)((Object)context), (String)"context must not be null");
        Assert.notNull(rootType, (String)"rootType must not be null");
        this.context = context;
        this.rootType = rootType;
        this.path = null;
        this.nestedCache = new ConcurrentLruCache(32, this::doGetAggegatePath);
    }

    @Override
    public AggregatePath getParentPath() {
        if (this.isRoot()) {
            throw new IllegalStateException("The parent path of a root path is not defined.");
        }
        PersistentPropertyPath<RelationalPersistentProperty> path = this.getRequiredPersistentPropertyPath();
        if (path.getLength() == 1) {
            return this.context.getAggregatePath(((RelationalPersistentProperty)path.getLeafProperty()).getOwner());
        }
        PersistentPropertyPath parentPath = path.getParentPath();
        Assert.state((parentPath != null ? 1 : 0) != 0, (String)"Parent path must not be null");
        return this.context.getAggregatePath((PersistentPropertyPath<? extends RelationalPersistentProperty>)parentPath);
    }

    @Override
    public AggregatePath append(RelationalPersistentProperty property) {
        return (AggregatePath)this.nestedCache.get((Object)property);
    }

    @Override
    public AggregatePath append(AggregatePath path) {
        if (path.isRoot()) {
            return this;
        }
        RelationalPersistentProperty baseProperty = path.getRequiredBaseProperty();
        AggregatePath appended = this.append(baseProperty);
        AggregatePath tail = path.getTail();
        return tail == null ? appended : appended.append(tail);
    }

    private AggregatePath doGetAggegatePath(RelationalPersistentProperty property) {
        PersistentPropertyPath newPath;
        if (this.isRoot()) {
            Assert.state((this.rootType != null ? 1 : 0) != 0, (String)"Root type must not be null");
            newPath = this.context.getPersistentPropertyPath(property.getName(), this.rootType.getTypeInformation());
        } else {
            Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path must not be null");
            newPath = this.context.getPersistentPropertyPath(this.path.toDotPath() + "." + property.getName(), ((RelationalPersistentProperty)this.path.getBaseProperty()).getOwner().getTypeInformation());
        }
        return this.context.getAggregatePath((PersistentPropertyPath<? extends RelationalPersistentProperty>)newPath);
    }

    @Override
    public boolean isRoot() {
        return this.path == null;
    }

    @Override
    public boolean isWritable() {
        return this.stream().allMatch(path -> path.isRoot() || path.getRequiredLeafProperty().isWritable());
    }

    @Override
    public boolean isEntity() {
        return this.isRoot() || this.getRequiredLeafProperty().isEntity();
    }

    @Override
    public boolean isEmbedded() {
        return !this.isRoot() && this.getRequiredLeafProperty().isEmbedded();
    }

    @Override
    public boolean isMultiValued() {
        return !this.isRoot() && (this.getRequiredLeafProperty().isCollectionLike() || this.getRequiredLeafProperty().isQualified() || this.getParentPath().isMultiValued());
    }

    @Override
    public boolean isQualified() {
        return !this.isRoot() && this.getRequiredLeafProperty().isQualified();
    }

    @Override
    public boolean isMap() {
        return !this.isRoot() && this.getRequiredLeafProperty().isMap();
    }

    @Override
    public boolean isCollectionLike() {
        return !this.isRoot() && this.getRequiredLeafProperty().isCollectionLike();
    }

    @Override
    public boolean isOrdered() {
        return !this.isRoot() && this.getRequiredLeafProperty().isOrdered();
    }

    @Override
    public boolean hasIdProperty() {
        RelationalPersistentEntity<?> leafEntity = this.getLeafEntity();
        return leafEntity != null && leafEntity.hasIdProperty();
    }

    @Override
    public RelationalPersistentProperty getRequiredIdProperty() {
        if (this.isRoot()) {
            Assert.state((this.rootType != null ? 1 : 0) != 0, (String)"Root type must not be null");
            return (RelationalPersistentProperty)this.rootType.getRequiredIdProperty();
        }
        return (RelationalPersistentProperty)this.getRequiredLeafEntity().getRequiredIdProperty();
    }

    @Override
    public PersistentPropertyPath<RelationalPersistentProperty> getRequiredPersistentPropertyPath() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Root Aggregate Paths are not associated with a PersistentPropertyPath");
        return this.path;
    }

    @Override
    public @Nullable RelationalPersistentEntity<?> getLeafEntity() {
        if (this.isRoot()) {
            return this.rootType;
        }
        TypeInformation actualType = this.getRequiredLeafProperty().getTypeInformation().getActualType();
        Assert.state((actualType != null ? 1 : 0) != 0, (String)"Actual type must not be null");
        return (RelationalPersistentEntity)this.context.getPersistentEntity(actualType);
    }

    @Override
    public String toDotPath() {
        return this.isRoot() ? "" : this.getRequiredPersistentPropertyPath().toDotPath();
    }

    @Override
    public AggregatePath getIdDefiningParentPath() {
        return AggregatePathTraversal.getIdDefiningPath(this);
    }

    @Override
    public @Nullable AggregatePath getTail() {
        if (this.getLength() <= 2) {
            return null;
        }
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path must not be null");
        AggregatePath tail = null;
        for (RelationalPersistentProperty prop : this.path) {
            if (tail == null) {
                RelationalPersistentEntity<?> entity = this.context.getPersistentEntity(prop);
                Assert.state((entity != null ? 1 : 0) != 0, (String)"Entity must not be null");
                tail = this.context.getAggregatePath(entity);
                continue;
            }
            tail = tail.append(prop);
        }
        return tail;
    }

    @Override
    public @Nullable AggregatePath subtract(@Nullable AggregatePath basePath) {
        if (basePath == null || basePath.isRoot()) {
            return this;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("Can't subtract from root path");
        }
        if (basePath.getRequiredBaseProperty().equals(this.getRequiredBaseProperty())) {
            AggregatePath tail = this.getTail();
            if (tail == null) {
                return null;
            }
            return tail.subtract(basePath.getTail());
        }
        throw new IllegalStateException("Can't subtract [%s] from [%s]".formatted(basePath, this));
    }

    @Override
    public AggregatePath getSubPathBasedOn(Class<?> baseType) {
        if (this.isRoot()) {
            Assert.state((this.rootType != null ? 1 : 0) != 0, (String)"Root type must not be null");
            if (this.rootType.getType() != baseType) {
                throw new IllegalStateException("No matching path found for [%s]".formatted(baseType));
            }
            return this;
        }
        RelationalPersistentEntity<?> owner = this.getRequiredBaseProperty().getOwner();
        if (owner.getType() == baseType) {
            return this;
        }
        AggregatePath tail = this.getRequiredTail();
        return tail.getSubPathBasedOn(baseType);
    }

    @Override
    public Iterator<AggregatePath> iterator() {
        return new AggregatePathIterator(this);
    }

    @Override
    public AggregatePath.TableInfo getTableInfo() {
        return (AggregatePath.TableInfo)this.tableInfo.get();
    }

    @Override
    public AggregatePath.ColumnInfo getColumnInfo() {
        return (AggregatePath.ColumnInfo)this.columnInfo.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAggregatePath that = (DefaultAggregatePath)o;
        return Objects.equals((Object)this.context, (Object)that.context) && Objects.equals(this.rootType, that.rootType) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.rootType, this.path});
    }

    public String toString() {
        String pathPart;
        String typeName;
        if (this.rootType == null) {
            Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path must not be null");
            typeName = ((RelationalPersistentProperty)this.path.getBaseProperty()).getOwner().getType().getName();
        } else {
            typeName = this.rootType.getName();
        }
        if (this.isRoot()) {
            pathPart = "/";
        } else {
            Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path must not be null");
            pathPart = this.path.toDotPath();
        }
        return "AggregatePath[" + typeName + "]" + pathPart;
    }

    private static class AggregatePathIterator
    implements Iterator<AggregatePath> {
        private @Nullable AggregatePath current;

        public AggregatePathIterator(AggregatePath current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public AggregatePath next() {
            AggregatePath element = this.current;
            if (element == null) {
                throw new NoSuchElementException();
            }
            this.current = element.isRoot() ? null : element.getParentPath();
            return element;
        }
    }
}

