/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.halexplorer;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.config.StaticResourceProvider;
import org.springframework.data.rest.webmvc.halexplorer.HalExplorer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;

@Configuration(proxyBeanMethods=false)
class HalExplorerConfiguration
implements StaticResourceProvider {
    HalExplorerConfiguration() {
    }

    public void customizeResources(ResourceHandlerRegistry registry, RepositoryRestConfiguration configuration) {
        String basePath = configuration.getBasePath().toString().concat("/explorer");
        String rootLocation = "classpath:META-INF/spring-data-rest/hal-explorer/";
        registry.addResourceHandler(new String[]{basePath.concat("/**")}).addResourceLocations(new String[]{rootLocation});
    }

    @Bean
    HalExplorer halExplorer() {
        return new HalExplorer();
    }
}

