/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.rest.core.Handler;
import org.springframework.data.rest.repository.JpaRepositoryMetadata;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JpaEntityMetadata {
    private Class<?> targetType;
    private Map<String, Attribute> embeddedAttributes = new HashMap<String, Attribute>();
    private Map<String, Field> fields = new HashMap<String, Field>();
    private Map<String, Method> setters = new HashMap<String, Method>();
    private Map<String, Method> getters = new HashMap<String, Method>();
    private Map<String, Attribute> linkedAttributes = new HashMap<String, Attribute>();
    private final Attribute idAttribute;
    private final Attribute versionAttribute;

    public JpaEntityMetadata(EntityType entityType, JpaRepositoryMetadata repositoryMetadata) {
        this.targetType = entityType.getJavaType();
        SingularAttribute idAttribute = entityType.getId(entityType.getIdType().getJavaType());
        SingularAttribute versionAttribute = entityType.getVersion(Long.class);
        for (Attribute attr : entityType.getAttributes()) {
            String name = attr.getName();
            Field f = ReflectionUtils.findField(this.targetType, (String)attr.getName());
            ReflectionUtils.makeAccessible((Field)f);
            this.fields.put(name, f);
            Method setter = null;
            try {
                setter = this.targetType.getMethod("set" + StringUtils.capitalize((String)name), attr.getJavaType());
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (null != setter) {
                this.setters.put(name, setter);
            }
            Method getter = null;
            try {
                getter = this.targetType.getMethod("get" + StringUtils.capitalize((String)name), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (null != setter) {
                this.getters.put(name, getter);
            }
            if (attr instanceof SingularAttribute) {
                SingularAttribute sattr = (SingularAttribute)attr;
                if (null != repositoryMetadata.repositoryFor(attr.getJavaType())) {
                    this.linkedAttributes.put(name, attr);
                    continue;
                }
                if (sattr.isId() || sattr.isVersion()) continue;
                this.embeddedAttributes.put(name, attr);
                continue;
            }
            if (!(attr instanceof PluralAttribute)) continue;
            PluralAttribute pattr = (PluralAttribute)attr;
            if (pattr.getElementType() instanceof EntityType && null != repositoryMetadata.repositoryFor(pattr.getElementType().getJavaType())) {
                this.linkedAttributes.put(name, attr);
                continue;
            }
            this.embeddedAttributes.put(name, attr);
        }
        this.idAttribute = idAttribute;
        this.versionAttribute = versionAttribute;
    }

    public Class<?> targetType() {
        return this.targetType;
    }

    public Map<String, Attribute> embeddedAttributes() {
        return Collections.unmodifiableMap(this.embeddedAttributes);
    }

    public Map<String, Attribute> linkedAttributes() {
        return Collections.unmodifiableMap(this.linkedAttributes);
    }

    public Attribute idAttribute() {
        return this.idAttribute;
    }

    public Attribute versionAttribute() {
        return this.versionAttribute;
    }

    public void id(Serializable id, Object target) {
        this.set(this.idAttribute.getName(), id, target);
    }

    public Object id(Object target) {
        return this.get(this.idAttribute.getName(), target);
    }

    public Object version(Object target) {
        return null != this.versionAttribute ? this.get(this.versionAttribute.getName(), target) : null;
    }

    public <V> V doWithEmbedded(Handler<Attribute, V> handler) {
        if (null == handler) {
            return null;
        }
        Object v = null;
        for (Attribute attr : this.embeddedAttributes.values()) {
            v = handler.handle((Object)attr);
        }
        return (V)v;
    }

    public <V> V doWithLinked(String name, Handler<Attribute, V> handler) {
        if (null == handler) {
            return null;
        }
        Object v = null;
        Attribute attr = this.linkedAttributes.get(name);
        if (null != attr) {
            v = handler.handle((Object)attr);
        }
        return (V)v;
    }

    public <V> V doWithLinked(Handler<Attribute, V> handler) {
        if (null == handler) {
            return null;
        }
        Object v = null;
        for (Attribute attr : this.linkedAttributes.values()) {
            v = handler.handle((Object)attr);
        }
        return (V)v;
    }

    public Object get(String name, Object target) {
        try {
            Method getter = this.getters.get(name);
            if (null != getter) {
                return getter.invoke(target, new Object[0]);
            }
            Field f = this.fields.get(name);
            return null != f ? f.get(target) : null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void set(String name, Object arg, Object target) {
        try {
            Method setter = this.setters.get(name);
            if (null != setter) {
                setter.invoke(target, arg);
            } else {
                Field f = this.fields.get(name);
                if (null != f) {
                    f.set(target, arg);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

