/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.rest.core.UriResolver;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.RepositoryExporterSupport;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.ClassUtils;

public class UriToDomainObjectUriResolver
extends RepositoryExporterSupport<UriToDomainObjectUriResolver>
implements UriResolver<Object> {
    @Autowired(required=false)
    private List<ConversionService> conversionServices = Arrays.asList(new DefaultFormattingConversionService());

    public List<ConversionService> getConversionServices() {
        return this.conversionServices;
    }

    public UriToDomainObjectUriResolver setConversionServices(List<ConversionService> conversionServices) {
        this.conversionServices = conversionServices;
        return this;
    }

    public Object resolve(URI baseUri, URI uri) {
        URI relativeUri = baseUri.relativize(uri);
        Stack uris = UriUtils.explode((URI)baseUri, (URI)relativeUri);
        if (uris.size() < 1) {
            return null;
        }
        String repoName = UriUtils.path((URI)((URI)uris.get(0)));
        String sId = UriUtils.path((URI)((URI)uris.get(1)));
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repoName);
        CrudRepository<Object, Serializable> repo = repoMeta.repository();
        if (null == repo) {
            return null;
        }
        Object entityMeta = repoMeta.entityMetadata();
        if (null == entityMeta) {
            return null;
        }
        Class<?> idType = entityMeta.idAttribute().type();
        Object serId = null;
        if (ClassUtils.isAssignable(idType, String.class)) {
            serId = sId;
        } else {
            for (ConversionService cs : this.conversionServices) {
                if (!cs.canConvert(String.class, idType)) continue;
                serId = (Serializable)cs.convert((Object)sId, idType);
                break;
            }
        }
        return repo.findOne((Serializable)serId);
    }
}

