/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.context;

import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.data.rest.repository.RepositoryExporter;
import org.springframework.data.rest.repository.RepositoryExporterSupport;
import org.springframework.data.rest.repository.context.AfterDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkSaveEvent;
import org.springframework.data.rest.repository.context.AfterSaveEvent;
import org.springframework.data.rest.repository.context.BeforeDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkSaveEvent;
import org.springframework.data.rest.repository.context.BeforeSaveEvent;
import org.springframework.data.rest.repository.context.RepositoryEvent;

public abstract class AbstractRepositoryEventListener<T extends AbstractRepositoryEventListener<? super T>>
extends RepositoryExporterSupport<T>
implements ApplicationListener<RepositoryEvent>,
ApplicationContextAware {
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    @Autowired
    public void setRepositoryExporters(List<RepositoryExporter> repositoryExporters) {
        super.setRepositoryExporters(repositoryExporters);
    }

    public final void onApplicationEvent(RepositoryEvent event) {
        if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave(event.getSource());
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave(event.getSource());
        } else if (event instanceof BeforeLinkSaveEvent) {
            this.onBeforeLinkSave(event.getSource(), ((BeforeLinkSaveEvent)event).getLinked());
        } else if (event instanceof AfterLinkSaveEvent) {
            this.onAfterLinkSave(event.getSource(), ((AfterLinkSaveEvent)event).getLinked());
        } else if (event instanceof BeforeLinkDeleteEvent) {
            this.onBeforeLinkDelete(event.getSource(), ((BeforeLinkDeleteEvent)event).getLinked());
        } else if (event instanceof AfterLinkDeleteEvent) {
            this.onAfterLinkDelete(event.getSource(), ((AfterLinkDeleteEvent)event).getLinked());
        } else if (event instanceof BeforeDeleteEvent) {
            this.onBeforeDelete(event.getSource());
        } else if (event instanceof AfterDeleteEvent) {
            this.onAfterDelete(event.getSource());
        }
    }

    protected void onBeforeSave(Object entity) {
    }

    protected void onAfterSave(Object entity) {
    }

    protected void onBeforeLinkSave(Object parent, Object linked) {
    }

    protected void onAfterLinkSave(Object parent, Object linked) {
    }

    protected void onBeforeLinkDelete(Object parent, Object linked) {
    }

    protected void onAfterLinkDelete(Object parent, Object linked) {
    }

    protected void onBeforeDelete(Object entity) {
    }

    protected void onAfterDelete(Object entity) {
    }
}

