/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.rest.repository.annotation.HandleAfterDelete;
import org.springframework.data.rest.repository.annotation.HandleAfterLinkSave;
import org.springframework.data.rest.repository.annotation.HandleAfterSave;
import org.springframework.data.rest.repository.annotation.HandleBeforeDelete;
import org.springframework.data.rest.repository.annotation.HandleBeforeLinkSave;
import org.springframework.data.rest.repository.annotation.HandleBeforeSave;
import org.springframework.data.rest.repository.annotation.RepositoryEventHandler;
import org.springframework.data.rest.repository.context.AfterDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkSaveEvent;
import org.springframework.data.rest.repository.context.AfterSaveEvent;
import org.springframework.data.rest.repository.context.BeforeDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkSaveEvent;
import org.springframework.data.rest.repository.context.BeforeSaveEvent;
import org.springframework.data.rest.repository.context.RepositoryEvent;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotatedHandlerRepositoryEventListener
implements ApplicationListener<RepositoryEvent>,
ApplicationContextAware,
InitializingBean {
    private String basePackage;
    private ApplicationContext applicationContext;
    private Multimap<Class<? extends RepositoryEvent>, EventHandlerMethod> handlerMethods = ArrayListMultimap.create();

    public AnnotatedHandlerRepositoryEventListener() {
    }

    public AnnotatedHandlerRepositoryEventListener(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public AnnotatedHandlerRepositoryEventListener setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public String basePackage() {
        return this.basePackage;
    }

    public AnnotatedHandlerRepositoryEventListener basePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RepositoryEventHandler.class, true, true));
        for (BeanDefinition beanDef : scanner.findCandidateComponents(this.basePackage)) {
            String typeName = beanDef.getBeanClassName();
            Class handlerType = ClassUtils.forName((String)typeName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            RepositoryEventHandler typeAnno = handlerType.getAnnotation(RepositoryEventHandler.class);
            Class<?>[] targetTypes = typeAnno.value();
            if (targetTypes.length == 0) {
                targetTypes = new Class[]{null};
            }
            for (final Class<?> targetType : targetTypes) {
                for (final Object handler : this.applicationContext.getBeansOfType(handlerType).values()) {
                    ReflectionUtils.doWithMethods(handler.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                            AnnotatedHandlerRepositoryEventListener.this.inspect(targetType, handler, method, HandleBeforeSave.class, BeforeSaveEvent.class);
                            AnnotatedHandlerRepositoryEventListener.this.inspect(targetType, handler, method, HandleAfterSave.class, AfterSaveEvent.class);
                            AnnotatedHandlerRepositoryEventListener.this.inspect(targetType, handler, method, HandleBeforeLinkSave.class, BeforeLinkSaveEvent.class);
                            AnnotatedHandlerRepositoryEventListener.this.inspect(targetType, handler, method, HandleAfterLinkSave.class, AfterLinkSaveEvent.class);
                            AnnotatedHandlerRepositoryEventListener.this.inspect(targetType, handler, method, HandleBeforeDelete.class, BeforeDeleteEvent.class);
                            AnnotatedHandlerRepositoryEventListener.this.inspect(targetType, handler, method, HandleAfterDelete.class, AfterDeleteEvent.class);
                        }
                    }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                        public boolean matches(Method method) {
                            return !method.isSynthetic() && !method.isBridge() && method.getDeclaringClass() != Object.class && !method.getName().contains("$");
                        }
                    });
                }
            }
        }
    }

    public void onApplicationEvent(RepositoryEvent event) {
        Class<?> eventType = ((Object)((Object)event)).getClass();
        if (!this.handlerMethods.containsKey(eventType)) {
            return;
        }
        for (EventHandlerMethod handlerMethod : this.handlerMethods.get(eventType)) {
            try {
                Object src = event.getSource();
                if (!ClassUtils.isAssignable(handlerMethod.targetType, src.getClass())) continue;
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(src);
                if (event instanceof BeforeLinkSaveEvent) {
                    params.add(((BeforeLinkSaveEvent)event).getLinked());
                } else if (event instanceof AfterLinkSaveEvent) {
                    params.add(((AfterLinkSaveEvent)event).getLinked());
                }
                handlerMethod.method.invoke(handlerMethod.handler, params.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private <T extends Annotation> void inspect(Class<?> targetType, Object handler, Method method, Class<T> annoType, Class<? extends RepositoryEvent> eventType) {
        T anno = method.getAnnotation(annoType);
        if (null != anno) {
            try {
                Class[] targetTypes = null == targetType ? (Class[])anno.getClass().getMethod("value", new Class[0]).invoke(anno, new Object[0]) : new Class[]{targetType};
                for (Class type : targetTypes) {
                    this.handlerMethods.put(eventType, (Object)new EventHandlerMethod(type, handler, method));
                }
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (InvocationTargetException ignored) {
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
        }
    }

    private class EventHandlerMethod {
        final Class<?> targetType;
        final Method method;
        final Object handler;

        private EventHandlerMethod(Class<?> targetType, Object handler, Method method) {
            this.targetType = targetType;
            this.method = method;
            this.handler = handler;
        }
    }
}

