/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.jpa;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import org.springframework.beans.BeanUtils;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.util.ReflectionUtils;

public class JpaAttributeMetadata
implements AttributeMetadata {
    private String name;
    private Attribute attribute;
    private Class<?> type;
    private Field field;
    private Method getter;
    private Method setter;

    public JpaAttributeMetadata(EntityType<?> entityType, Attribute attribute) {
        this.attribute = attribute;
        this.name = attribute.getName();
        this.type = attribute.getJavaType();
        this.field = ReflectionUtils.findField((Class)entityType.getJavaType(), (String)this.name);
        ReflectionUtils.makeAccessible((Field)this.field);
        PropertyDescriptor property = BeanUtils.getPropertyDescriptor((Class)entityType.getJavaType(), (String)this.name);
        if (null != property) {
            this.getter = property.getReadMethod();
            if (null != this.getter) {
                ReflectionUtils.makeAccessible((Method)this.getter);
            }
            this.setter = property.getWriteMethod();
            if (null != this.setter) {
                ReflectionUtils.makeAccessible((Method)this.setter);
            }
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public Class<?> keyType() {
        return this.attribute instanceof MapAttribute ? ((MapAttribute)this.attribute).getKeyJavaType() : null;
    }

    @Override
    public Class<?> elementType() {
        return this.attribute instanceof PluralAttribute ? ((PluralAttribute)this.attribute).getElementType().getJavaType() : null;
    }

    @Override
    public boolean isNullable() {
        if (this.hasAnnotation(ManyToOne.class)) {
            return this.annotation(ManyToOne.class).optional();
        }
        if (this.hasAnnotation(OneToOne.class)) {
            return this.annotation(OneToOne.class).optional();
        }
        return true;
    }

    @Override
    public boolean isCollectionLike() {
        if (this.attribute instanceof PluralAttribute) {
            PluralAttribute plattr = (PluralAttribute)this.attribute;
            switch (plattr.getCollectionType()) {
                case COLLECTION: 
                case LIST: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public Collection<?> asCollection(Object target) {
        return (Collection)this.get(target);
    }

    @Override
    public boolean isSetLike() {
        if (this.attribute instanceof PluralAttribute) {
            PluralAttribute plattr = (PluralAttribute)this.attribute;
            switch (plattr.getCollectionType()) {
                case SET: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public Set<?> asSet(Object target) {
        return (Set)this.get(target);
    }

    @Override
    public boolean isMapLike() {
        if (this.attribute instanceof PluralAttribute) {
            PluralAttribute plattr = (PluralAttribute)this.attribute;
            switch (plattr.getCollectionType()) {
                case MAP: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public Map asMap(Object target) {
        return (Map)this.get(target);
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annoType) {
        return this.field.isAnnotationPresent(annoType);
    }

    @Override
    public <A extends Annotation> A annotation(Class<A> annoType) {
        return this.field.getAnnotation(annoType);
    }

    @Override
    public Object get(Object target) {
        try {
            if (null != this.getter) {
                return this.getter.invoke(target, new Object[0]);
            }
            return this.field.get(target);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AttributeMetadata set(Object value, Object target) {
        try {
            if (null != this.setter) {
                this.setter.invoke(target, value);
            } else {
                this.field.set(target, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String toString() {
        return "JpaAttributeMetadata{name='" + this.name + '\'' + ", attribute=" + this.attribute + ", type=" + this.type + ", field=" + this.field + ", getter=" + this.getter + ", setter=" + this.setter + '}';
    }
}

