/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.rest.config.ResourceMapping;

public class ResourceMappingConfiguration {
    private final Map<Class<?>, ResourceMapping> resourceMappings = new HashMap();

    public ResourceMapping addResourceMappingFor(Class<?> type) {
        ResourceMapping rm = this.resourceMappings.get(type);
        if (null == rm) {
            rm = new ResourceMapping(type);
            this.resourceMappings.put(type, rm);
        }
        return rm;
    }

    public ResourceMapping getResourceMappingFor(Class<?> type) {
        return this.resourceMappings.get(type);
    }

    public boolean hasResourceMappingFor(Class<?> type) {
        return this.resourceMappings.containsKey(type);
    }

    public Class<?> findTypeForPath(String path) {
        if (null == path) {
            return null;
        }
        for (Map.Entry<Class<?>, ResourceMapping> entry : this.resourceMappings.entrySet()) {
            if (!path.equals(entry.getValue().getPath())) continue;
            return entry.getKey();
        }
        return null;
    }
}

