/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.BaseUriAwareResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public class BaseUriAwareResources
extends Resources<Resource<?>> {
    @JsonIgnore
    private URI baseUri;

    public BaseUriAwareResources() {
    }

    public BaseUriAwareResources(Iterable<Resource<?>> content, Link ... links) {
        super(content, links);
    }

    public BaseUriAwareResources(Iterable<Resource<?>> content, Iterable<Link> links) {
        super(content, links);
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public BaseUriAwareResources setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public Collection<Resource<?>> getContent() {
        ArrayList resources = new ArrayList();
        for (Resource resource : super.getContent()) {
            if (resource instanceof BaseUriAwareResource) {
                resources.add(((BaseUriAwareResource)resource).setBaseUri(this.baseUri));
                continue;
            }
            resources.add(new BaseUriAwareResource<Object>(resource.getContent(), resource.getLinks()).setBaseUri(this.baseUri));
        }
        return resources;
    }

    public Iterator<Resource<?>> iterator() {
        return this.getContent().iterator();
    }

    public List<Link> getLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link l : super.getLinks()) {
            links.add(new Link(UriUtils.buildUri((URI)this.baseUri, (String[])new String[]{l.getHref()}).toString(), l.getRel()));
        }
        return links;
    }

    public Link getLink(String rel) {
        Link l = super.getLink(rel);
        return new Link(UriUtils.buildUri((URI)this.baseUri, (String[])new String[]{l.getHref()}).toString(), l.getRel());
    }
}

