/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidationErrors
extends AbstractErrors {
    private String name;
    private Object entity;
    private PersistentEntity persistentEntity;
    private List<ObjectError> globalErrors = new ArrayList<ObjectError>();
    private List<FieldError> fieldErrors = new ArrayList<FieldError>();

    public ValidationErrors(String name, Object entity, PersistentEntity persistentEntity) {
        this.name = name;
        this.entity = entity;
        this.persistentEntity = persistentEntity;
    }

    public String getObjectName() {
        return this.name;
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.globalErrors.add(new ObjectError(this.name, new String[]{errorCode}, errorArgs, defaultMessage));
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        this.fieldErrors.add(new FieldError(this.name, field, this.getFieldValue(field), true, new String[]{errorCode}, errorArgs, defaultMessage));
    }

    public void addAllErrors(Errors errors) {
        this.globalErrors.addAll(errors.getAllErrors());
    }

    public List<ObjectError> getGlobalErrors() {
        return this.globalErrors;
    }

    public List<FieldError> getFieldErrors() {
        return this.fieldErrors;
    }

    public Object getFieldValue(String field) {
        PersistentProperty prop;
        PersistentProperty persistentProperty = prop = null != this.persistentEntity ? this.persistentEntity.getPersistentProperty(field) : null;
        if (null == prop) {
            return null;
        }
        Method getter = prop.getGetter();
        if (null != getter) {
            return ReflectionUtils.invokeMethod((Method)getter, (Object)this.entity);
        }
        Field fld = prop.getField();
        if (null != fld) {
            return ReflectionUtils.getField((Field)fld, (Object)this.entity);
        }
        return null;
    }
}

