/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.repository.annotation.HandleAfterCreate;
import org.springframework.data.rest.repository.annotation.HandleAfterDelete;
import org.springframework.data.rest.repository.annotation.HandleAfterLinkDelete;
import org.springframework.data.rest.repository.annotation.HandleAfterLinkSave;
import org.springframework.data.rest.repository.annotation.HandleAfterSave;
import org.springframework.data.rest.repository.annotation.HandleBeforeCreate;
import org.springframework.data.rest.repository.annotation.HandleBeforeDelete;
import org.springframework.data.rest.repository.annotation.HandleBeforeLinkDelete;
import org.springframework.data.rest.repository.annotation.HandleBeforeLinkSave;
import org.springframework.data.rest.repository.annotation.HandleBeforeSave;
import org.springframework.data.rest.repository.annotation.RepositoryEventHandler;
import org.springframework.data.rest.repository.context.AfterCreateEvent;
import org.springframework.data.rest.repository.context.AfterDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkSaveEvent;
import org.springframework.data.rest.repository.context.AfterSaveEvent;
import org.springframework.data.rest.repository.context.BeforeCreateEvent;
import org.springframework.data.rest.repository.context.BeforeDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkSaveEvent;
import org.springframework.data.rest.repository.context.BeforeSaveEvent;
import org.springframework.data.rest.repository.context.RepositoryEvent;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotatedHandlerBeanPostProcessor
implements ApplicationListener<RepositoryEvent>,
BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedHandlerBeanPostProcessor.class);
    private Multimap<Class<? extends RepositoryEvent>, EventHandlerMethod> handlerMethods = ArrayListMultimap.create();

    public void onApplicationEvent(RepositoryEvent event) {
        Class<?> eventType = ((Object)((Object)event)).getClass();
        if (!this.handlerMethods.containsKey(eventType)) {
            return;
        }
        for (EventHandlerMethod handlerMethod : this.handlerMethods.get(eventType)) {
            try {
                Object src = event.getSource();
                if (!ClassUtils.isAssignable(handlerMethod.targetType, src.getClass())) continue;
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(src);
                if (event instanceof BeforeLinkSaveEvent) {
                    params.add(((BeforeLinkSaveEvent)event).getLinked());
                } else if (event instanceof AfterLinkSaveEvent) {
                    params.add(((AfterLinkSaveEvent)event).getLinked());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + ((Object)((Object)event)).getClass().getSimpleName() + " handler for " + event.getSource());
                }
                handlerMethod.method.invoke(handlerMethod.handler, params.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class<?> beanType = bean.getClass();
        RepositoryEventHandler typeAnno = (RepositoryEventHandler)AnnotationUtils.findAnnotation(beanType, RepositoryEventHandler.class);
        if (null == typeAnno) {
            return bean;
        }
        Class<?>[] targetTypes = typeAnno.value();
        if (targetTypes.length == 0) {
            targetTypes = new Class[]{null};
        }
        for (final Class<?> targetType : targetTypes) {
            ReflectionUtils.doWithMethods(beanType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleBeforeCreate.class, BeforeCreateEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleAfterCreate.class, AfterCreateEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleBeforeSave.class, BeforeSaveEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleAfterSave.class, AfterSaveEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleBeforeLinkSave.class, BeforeLinkSaveEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleAfterLinkSave.class, AfterLinkSaveEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleBeforeDelete.class, BeforeDeleteEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleAfterDelete.class, AfterDeleteEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleBeforeLinkDelete.class, BeforeLinkDeleteEvent.class);
                    AnnotatedHandlerBeanPostProcessor.this.inspect(targetType, bean, method, HandleAfterLinkDelete.class, AfterLinkDeleteEvent.class);
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return !method.isSynthetic() && !method.isBridge() && method.getDeclaringClass() != Object.class && !method.getName().contains("$");
                }
            });
        }
        return bean;
    }

    private <T extends Annotation> void inspect(Class<?> targetType, Object handler, Method method, Class<T> annoType, Class<? extends RepositoryEvent> eventType) {
        block9: {
            T anno = method.getAnnotation(annoType);
            if (null != anno) {
                try {
                    Class[] targetTypes = null == targetType ? (Class[])anno.getClass().getMethod("value", new Class[0]).invoke(anno, new Object[0]) : new Class[]{targetType};
                    for (Class type : targetTypes) {
                        EventHandlerMethod m = new EventHandlerMethod(type, handler, method);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Annotated handler method found: " + m);
                        }
                        this.handlerMethods.put(eventType, (Object)m);
                    }
                }
                catch (NoSuchMethodException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
                catch (InvocationTargetException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class EventHandlerMethod {
        final Class<?> targetType;
        final Method method;
        final Object handler;

        private EventHandlerMethod(Class<?> targetType, Object handler, Method method) {
            this.targetType = targetType;
            this.method = method;
            this.handler = handler;
        }

        public String toString() {
            return "EventHandlerMethod{targetType=" + this.targetType + ", method=" + this.method + ", handler=" + this.handler + '}';
        }
    }
}

