/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.invoke;

import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.rest.repository.annotation.ConvertWith;
import org.springframework.util.Assert;

public class MethodParameterConversionService {
    private final ConversionService delegateConversionService;

    public MethodParameterConversionService(ConversionService delegateConversionService) {
        Assert.notNull((Object)delegateConversionService, (String)"Delegate ConversionService cannot be null.");
        this.delegateConversionService = delegateConversionService;
    }

    public boolean canConvert(Class<?> sourceType, MethodParameter param) {
        return this.canConvert(TypeDescriptor.valueOf(sourceType), param);
    }

    public boolean canConvert(TypeDescriptor sourceType, MethodParameter param) {
        return this.delegateConversionService.canConvert(sourceType, new TypeDescriptor(param)) || param.hasParameterAnnotation(ConvertWith.class);
    }

    public <T> T convert(Object source, MethodParameter param) {
        return this.convert(source, TypeDescriptor.forObject((Object)source), param);
    }

    public <T> T convert(Object source, TypeDescriptor sourceType, MethodParameter param) {
        TypeDescriptor targetType = new TypeDescriptor(param);
        try {
            if (param.hasParameterAnnotation(ConvertWith.class)) {
                Converter<?, ?> converter = ((ConvertWith)param.getParameterAnnotation(ConvertWith.class)).value().newInstance();
                return (T)converter.convert(source);
            }
            return (T)this.delegateConversionService.convert(source, sourceType, targetType);
        }
        catch (Exception e) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)e);
        }
    }
}

