/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.invoke;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.repository.support.Methods;

public class RepositoryMethod {
    private Method method;
    private List<MethodParameter> methodParameters = new ArrayList<MethodParameter>();
    private List<String> paramNames = new ArrayList<String>();
    private boolean pageable = false;
    private boolean sortable = false;

    public RepositoryMethod(Method method) {
        this.method = method;
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] paramNames = Methods.NAME_DISCOVERER.getParameterNames(method);
        if (null == paramNames) {
            paramNames = new String[paramTypes.length];
        }
        Annotation[][] paramAnnos = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnos.length; ++i) {
            if (paramAnnos[i].length > 0) {
                for (Annotation anno : paramAnnos[i]) {
                    if (!Param.class.isAssignableFrom(anno.getClass())) continue;
                    Param p = (Param)anno;
                    paramNames[i] = p.value();
                    break;
                }
            }
            if (null != paramNames[i]) continue;
            paramNames[i] = "arg" + i;
        }
        int idx = 0;
        for (Class<?> type : paramTypes) {
            if (Pageable.class.isAssignableFrom(type)) {
                this.pageable = true;
            }
            if (Sort.class.isAssignableFrom(type)) {
                this.sortable = true;
            }
            this.methodParameters.add(new MethodParameter(method, idx));
            ++idx;
        }
        Collections.addAll(this.paramNames, paramNames);
    }

    public List<MethodParameter> getParameters() {
        return this.methodParameters;
    }

    public List<String> getParameterNames() {
        return this.paramNames;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public boolean isSortable() {
        return this.sortable;
    }
}

