/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.invoke;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.hateoas.Link;

public class RepositoryMethodResponse {
    @JsonProperty(value="results")
    private List<Object> results = new ArrayList<Object>();
    @JsonProperty(value="links")
    private List<Link> links = new ArrayList<Link>();
    private long totalCount = 0L;
    private int totalPages = 1;
    private int currentPage = 1;

    public RepositoryMethodResponse addLink(Link l) {
        this.links.add(l);
        return this;
    }

    public RepositoryMethodResponse addResult(Object obj) {
        this.results.add(obj);
        return this;
    }

    public RepositoryMethodResponse addAllResults(Iterator results) {
        if (null == results) {
            return this;
        }
        while (results.hasNext()) {
            this.addResult(results.next());
        }
        return this;
    }

    public List<Object> getResults() {
        return this.results;
    }

    public boolean hasResults() {
        return this.results.size() > 0;
    }

    public RepositoryMethodResponse setResults(List<Object> results) {
        this.results = null == results ? Collections.emptyList() : results;
        return this;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public RepositoryMethodResponse setLinks(List<Link> links) {
        this.links = null == links ? Collections.emptyList() : links;
        return this;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public RepositoryMethodResponse setTotalCount(long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public RepositoryMethodResponse setTotalPages(int totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public RepositoryMethodResponse setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        return this;
    }
}

