/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;

public class JsonSchema
extends Resource<Map<String, Property>> {
    private final String name;
    private final String description;

    public JsonSchema(String name, String description) {
        super(new HashMap(), new Link[0]);
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="properties")
    public Map<String, Property> getContent() {
        return (Map)super.getContent();
    }

    public JsonSchema addProperty(String name, Property property) {
        this.getContent().put(name, property);
        return this;
    }

    public boolean isArrayProperty(String name) {
        return this.getContent().containsKey(name) && this.getContent().get(name) instanceof ArrayProperty;
    }

    public ArrayProperty getArrayProperty(String name) {
        return (ArrayProperty)this.getContent().get(name);
    }

    public static class ArrayProperty
    extends Property {
        private List<Property> items = new ArrayList<Property>();

        public ArrayProperty(String type, String description, boolean required) {
            super(type, description, required);
        }

        public List<? extends Property> getItems() {
            return this.items;
        }

        public ArrayProperty setItems(List<Property> items) {
            this.items = items;
            return this;
        }

        public <P extends Property> ArrayProperty addItem(P item) {
            this.items.add(item);
            return this;
        }
    }

    public static class Property {
        private final String type;
        private final String description;
        private final boolean required;

        public Property(String type, String description, boolean required) {
            this.type = type;
            this.description = description;
            this.required = required;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

