/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.PersistentEntityResource;
import org.springframework.data.rest.repository.UriDomainClassConverter;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.hateoas.Link;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class PersistentEntityJackson2Module
extends SimpleModule
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJackson2Module.class);
    private static final TypeDescriptor URI_TYPE = TypeDescriptor.valueOf(URI.class);
    private final ConversionService conversionService;
    @Autowired
    private Repositories repositories;
    @Autowired
    private RepositoryRestConfiguration config;
    @Autowired
    private UriDomainClassConverter uriDomainClassConverter;

    public PersistentEntityJackson2Module(ConversionService conversionService) {
        super(new Version(1, 1, 0, "BUILD-SNAPSHOT", "org.springframework.data.rest", "jackson-module"));
        this.conversionService = conversionService;
        this.addSerializer((JsonSerializer)new ResourceSerializer());
    }

    public static boolean maybeAddAssociationLink(Repositories repositories, RepositoryRestConfiguration config, URI baseEntityUri, RepositoryInformation repoInfo, ResourceMapping entityMapping, ResourceMapping propertyMapping, PersistentProperty persistentProperty, List<Link> links) {
        RepositoryInformation linkedRepoInfo;
        ResourceMapping linkedRepoMapping;
        String propertyPath;
        Class propertyType = persistentProperty.getType();
        if (persistentProperty.isCollectionLike() || persistentProperty.isArray()) {
            propertyType = persistentProperty.getComponentType();
        }
        String string = propertyPath = null != propertyMapping ? propertyMapping.getPath() : persistentProperty.getName();
        if (null == propertyPath) {
            propertyPath = persistentProperty.getName();
        }
        String propertyRel = ResourceMappingUtils.formatRel(config, repoInfo, persistentProperty);
        if (repositories.hasRepositoryFor(propertyType) && (linkedRepoMapping = ResourceMappingUtils.getResourceMapping(config, linkedRepoInfo = repositories.getRepositoryInformationFor(propertyType))).isExported()) {
            URI uri = UriUtils.buildUri((URI)baseEntityUri, (String[])new String[]{propertyPath});
            Link l = new Link(uri.toString(), propertyRel);
            links.add(l);
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        for (Class domainType : this.repositories) {
            PersistentEntity pe = this.repositories.getPersistentEntity(domainType);
            if (null == pe) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("The domain class {} does not have PersistentEntity metadata.", (Object)domainType.getName());
                continue;
            }
            this.addDeserializer(domainType, (JsonDeserializer)new ResourceDeserializer(pe));
        }
    }

    private class ResourceSerializer
    extends StdSerializer<PersistentEntityResource> {
        private ResourceSerializer() {
            super(PersistentEntityResource.class);
        }

        public void serialize(PersistentEntityResource resource, final JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serializing PersistentEntity " + resource.getPersistentEntity());
            }
            Object obj = resource.getContent();
            final PersistentEntity persistentEntity = resource.getPersistentEntity();
            final ResourceMapping entityMapping = ResourceMappingUtils.getResourceMapping(PersistentEntityJackson2Module.this.config, persistentEntity);
            final RepositoryInformation repoInfo = PersistentEntityJackson2Module.this.repositories.getRepositoryInformationFor(persistentEntity.getType());
            ResourceMapping repoMapping = ResourceMappingUtils.getResourceMapping(PersistentEntityJackson2Module.this.config, repoInfo);
            final BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)PersistentEntityJackson2Module.this.conversionService);
            Object entityId = wrapper.getProperty(persistentEntity.getIdProperty());
            final URI baseEntityUri = UriUtils.buildUri((URI)resource.getBaseUri(), (String[])new String[]{repoMapping.getPath(), entityId.toString()});
            final ArrayList<Link> links = new ArrayList<Link>();
            links.addAll(resource.getLinks());
            jgen.writeStartObject();
            try {
                persistentEntity.doWithProperties(new PropertyHandler(){

                    public void doWithPersistentProperty(PersistentProperty persistentProperty) {
                        if (persistentProperty.isIdProperty() && !PersistentEntityJackson2Module.this.config.isIdExposedFor(persistentEntity.getType())) {
                            return;
                        }
                        ResourceMapping propertyMapping = entityMapping.getResourceMappingFor(persistentProperty.getName());
                        if (null != propertyMapping && !propertyMapping.isExported()) {
                            return;
                        }
                        if (persistentProperty.isEntity() && PersistentEntityJackson2Module.maybeAddAssociationLink(PersistentEntityJackson2Module.this.repositories, PersistentEntityJackson2Module.this.config, baseEntityUri, repoInfo, entityMapping, propertyMapping, persistentProperty, links)) {
                            return;
                        }
                        String propertyName = null != propertyMapping ? propertyMapping.getPath() : persistentProperty.getName();
                        Object propertyValue = wrapper.getProperty(persistentProperty);
                        try {
                            jgen.writeObjectField(propertyName, propertyValue);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                });
                persistentEntity.doWithAssociations(new AssociationHandler(){

                    public void doWithAssociation(Association association) {
                        PersistentProperty persistentProperty = association.getInverse();
                        ResourceMapping propertyMapping = entityMapping.getResourceMappingFor(persistentProperty.getName());
                        if (null != propertyMapping && !propertyMapping.isExported()) {
                            return;
                        }
                        if (PersistentEntityJackson2Module.maybeAddAssociationLink(PersistentEntityJackson2Module.this.repositories, PersistentEntityJackson2Module.this.config, baseEntityUri, repoInfo, entityMapping, propertyMapping, persistentProperty, links)) {
                            return;
                        }
                        Object propertyValue = wrapper.getProperty(persistentProperty);
                        try {
                            jgen.writeObjectField(persistentProperty.getName(), propertyValue);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                });
                jgen.writeArrayFieldStart("links");
                for (Link l : links) {
                    jgen.writeObject((Object)l);
                }
                jgen.writeEndArray();
            }
            catch (IllegalStateException e) {
                throw (IOException)e.getCause();
            }
            finally {
                jgen.writeEndObject();
            }
        }
    }

    private class ResourceDeserializer<T>
    extends StdDeserializer<T> {
        private final PersistentEntity persistentEntity;

        private ResourceDeserializer(PersistentEntity persistentEntity) {
            super(persistentEntity.getType());
            this.persistentEntity = persistentEntity;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object entity = BeanUtils.instantiateClass((Class)this.getValueClass());
            BeanWrapper wrapper = BeanWrapper.create((Object)entity, (ConversionService)PersistentEntityJackson2Module.this.conversionService);
            ResourceMapping domainMapping = PersistentEntityJackson2Module.this.config.getResourceMappingForDomainType(this.getValueClass());
            JsonToken tok = jp.nextToken();
            while (tok != JsonToken.END_OBJECT) {
                String name = jp.getCurrentName();
                switch (tok) {
                    case FIELD_NAME: {
                        void var9_21;
                        if ("href".equals(name)) {
                            URI uri = URI.create(jp.nextTextValue());
                            TypeDescriptor typeDescriptor = TypeDescriptor.forObject((Object)entity);
                            if (!PersistentEntityJackson2Module.this.uriDomainClassConverter.matches(URI_TYPE, typeDescriptor)) break;
                            entity = PersistentEntityJackson2Module.this.uriDomainClassConverter.convert(uri, URI_TYPE, typeDescriptor);
                            break;
                        }
                        if ("rel".equals(name)) break;
                        PersistentProperty persistentProperty = this.persistentEntity.getPersistentProperty(name);
                        if (null == persistentProperty) {
                            String string = "Property '" + name + "' not found for entity " + this.getValueClass().getName();
                            if (null == domainMapping) {
                                throw new HttpMessageNotReadableException(string);
                            }
                            String propertyName = domainMapping.getNameForPath(name);
                            if (null == propertyName) {
                                throw new HttpMessageNotReadableException(string);
                            }
                            persistentProperty = this.persistentEntity.getPersistentProperty(propertyName);
                            if (null == persistentProperty) {
                                throw new HttpMessageNotReadableException(string);
                            }
                        }
                        Object var9_13 = null;
                        if ("links".equals(name)) {
                            tok = jp.nextToken();
                            if (tok == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                }
                                break;
                            }
                            if (tok == JsonToken.VALUE_NULL) break;
                            throw new HttpMessageNotReadableException("Property 'links' is not of array type. Either eliminate this property from the document or make it an array.");
                        }
                        if (null == persistentProperty) break;
                        if (persistentProperty.isCollectionLike()) {
                            Class ctype = persistentProperty.getType();
                            AbstractCollection c = (ArrayList)wrapper.getProperty(persistentProperty, ctype, false);
                            if (null == c || c == Collections.EMPTY_LIST || c == Collections.EMPTY_SET) {
                                if (Collection.class.isAssignableFrom(ctype)) {
                                    c = new ArrayList();
                                } else if (Set.class.isAssignableFrom(ctype)) {
                                    c = new HashSet();
                                }
                            }
                            if ((tok = jp.nextToken()) == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                    Object cval = jp.readValueAs(persistentProperty.getComponentType());
                                    c.add(cval);
                                }
                                AbstractCollection abstractCollection = c;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Collection.");
                                Object var9_15 = null;
                            }
                        } else if (persistentProperty.isMap()) {
                            Class mtype = persistentProperty.getType();
                            HashMap<String, Object> m = (HashMap<String, Object>)wrapper.getProperty(persistentProperty, mtype, false);
                            if (null == m || m == Collections.EMPTY_MAP) {
                                m = new HashMap<String, Object>();
                            }
                            if ((tok = jp.nextToken()) == JsonToken.START_OBJECT) {
                                do {
                                    name = jp.getCurrentName();
                                    tok = jp.nextToken();
                                    Object mval = jp.readValueAs(persistentProperty.getMapValueType());
                                    m.put(name, mval);
                                } while ((tok = jp.nextToken()) != JsonToken.END_OBJECT);
                                HashMap<String, Object> hashMap = m;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Map.");
                                Object var9_18 = null;
                            }
                        } else {
                            tok = jp.nextToken();
                            if (tok != JsonToken.VALUE_NULL) {
                                Object object = jp.readValueAs(persistentProperty.getType());
                            }
                        }
                        wrapper.setProperty(persistentProperty, (Object)var9_21, false);
                        break;
                    }
                }
                tok = jp.nextToken();
            }
            return (T)entity;
        }
    }
}

