/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.ser.CustomSerializerFactory;
import org.springframework.data.rest.core.SimpleLink;
import org.springframework.data.rest.core.util.FluentBeanSerializer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.view.AbstractView;

public class JsonView
extends AbstractView {
    private ObjectMapper mapper = new ObjectMapper();

    public JsonView(String mediaType) {
        CustomSerializerFactory customSerializerFactory = new CustomSerializerFactory();
        customSerializerFactory.addSpecificMapping(SimpleLink.class, (JsonSerializer)new FluentBeanSerializer(SimpleLink.class));
        this.mapper.setSerializerFactory((SerializerFactory)customSerializerFactory);
        this.setContentType(mediaType);
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpStatus status = this.status(model);
        response.setStatus(status.value());
        String contentType = this.getContentType();
        HttpHeaders headers = this.headers(model);
        if (null != headers) {
            for (Map.Entry entry : headers.toSingleValueMap().entrySet()) {
                response.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
            if (null != headers.getContentType()) {
                contentType = headers.getContentType().toString();
            }
        }
        response.setContentType(contentType);
        Object resource = model.get("resource");
        if (null != resource) {
            if (resource instanceof Throwable) {
                resource = ((Throwable)resource).getMessage();
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)bout, resource);
            response.getOutputStream().write(bout.toByteArray());
        } else {
            response.setContentLength(0);
        }
    }

    private HttpStatus status(Map<String, Object> model) {
        Object o = model.get("status");
        if (null != o && o instanceof HttpStatus) {
            return (HttpStatus)o;
        }
        throw new IllegalArgumentException("No status is set in the model.");
    }

    private HttpHeaders headers(Map<String, Object> model) {
        Object o = model.get("headers");
        if (null != o && o instanceof HttpHeaders) {
            return (HttpHeaders)o;
        }
        return null;
    }
}

